/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.annotation.Default;
import org.springframework.integration.annotation.Payloads;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.UseSpelInvoker;
import org.springframework.integration.config.HandlerMethodArgumentResolversHolder;
import org.springframework.integration.handler.support.CollectionArgumentResolver;
import org.springframework.integration.handler.support.MapArgumentResolver;
import org.springframework.integration.handler.support.PayloadExpressionArgumentResolver;
import org.springframework.integration.handler.support.PayloadsArgumentResolver;
import org.springframework.integration.support.MutableMessage;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapperProvider;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.integration.util.AnnotatedMethodFilter;
import org.springframework.integration.util.ClassUtils;
import org.springframework.integration.util.FixedMethodFilter;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.integration.util.UniqueMethodFilter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessagingMethodInvokerHelper<T>
extends AbstractExpressionEvaluator
implements Lifecycle {
    private static final String CANDIDATE_METHODS = "CANDIDATE_METHODS";
    private static final String CANDIDATE_MESSAGE_METHODS = "CANDIDATE_MESSAGE_METHODS";
    private static final Log logger = LogFactory.getLog(MessagingMethodInvokerHelper.class);
    private static final int FAILED_ATTEMPTS_THRESHOLD = 100;
    private static final ExpressionParser EXPRESSION_PARSER_DEFAULT = EXPRESSION_PARSER;
    private static final ExpressionParser EXPRESSION_PARSER_OFF = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.OFF, null));
    private static final ExpressionParser EXPRESSION_PARSER_IMMEDIATE = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, null));
    private static final ExpressionParser EXPRESSION_PARSER_MIXED = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new LocalVariableTableParameterNameDiscoverer();
    private static final Map<SpelCompilerMode, ExpressionParser> SPEL_COMPILERS = new HashMap<SpelCompilerMode, ExpressionParser>();
    private static final TypeDescriptor messageTypeDescriptor = TypeDescriptor.valueOf(Message.class);
    private static final Collection<Message<?>> dummyMessages = Collections.emptyList();
    private static final TypeDescriptor messageListTypeDescriptor = new TypeDescriptor(ReflectionUtils.findField(MessagingMethodInvokerHelper.class, (String)"dummyMessages"));
    private static final TypeDescriptor messageArrayTypeDescriptor = TypeDescriptor.valueOf(Message[].class);
    private final DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
    private final Object targetObject;
    private final JsonObjectMapper<?, ?> jsonObjectMapper;
    private volatile String displayString;
    private volatile boolean requiresReply;
    private final Map<Class<?>, HandlerMethod> handlerMethods;
    private final Map<Class<?>, HandlerMethod> handlerMessageMethods;
    private final List<Map<Class<?>, HandlerMethod>> handlerMethodsList;
    private final HandlerMethod handlerMethod;
    private final TypeDescriptor expectedType;
    private final boolean canProcessMessageList;
    private Class<? extends Annotation> annotationType;
    private volatile boolean initialized;
    private String methodName;
    private Method method;
    private boolean useSpelInvoker;
    private HandlerMethod defaultHandlerMethod;
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;

    public MessagingMethodInvokerHelper(Object targetObject, Method method, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, null, method, expectedType, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Method method, boolean canProcessMessageList) {
        this(targetObject, method, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, String methodName, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, null, methodName, expectedType, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, String methodName, boolean canProcessMessageList) {
        this(targetObject, methodName, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, boolean canProcessMessageList) {
        this(targetObject, annotationType, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, annotationType, (String)null, expectedType, canProcessMessageList);
    }

    private MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Method method, Class<?> expectedType, boolean canProcessMessageList) {
        JsonObjectMapper<?, ?> mapper;
        this.annotationType = annotationType;
        this.canProcessMessageList = canProcessMessageList;
        Assert.notNull((Object)method, (String)"method must not be null");
        this.method = method;
        boolean bl = this.requiresReply = expectedType != null;
        if (expectedType != null) {
            Assert.isTrue((method.getReturnType() != Void.class && method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"method must have a return type");
            this.expectedType = TypeDescriptor.valueOf(expectedType);
        } else {
            this.expectedType = null;
        }
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.targetObject = targetObject;
        try {
            InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(targetObject, method);
            this.handlerMethod = new HandlerMethod(invocableHandlerMethod, canProcessMessageList);
            this.defaultHandlerMethod = null;
            this.checkSpelInvokerRequired(this.getTargetClass(targetObject), method, this.handlerMethod);
        }
        catch (IneligibleMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.handlerMethods = null;
        this.handlerMessageMethods = null;
        this.handlerMethodsList = null;
        this.setDisplayString(targetObject, method);
        try {
            mapper = JsonObjectMapperProvider.newInstance();
        }
        catch (IllegalStateException e) {
            mapper = null;
        }
        this.jsonObjectMapper = mapper;
    }

    public void setUseSpelInvoker(boolean useSpelInvoker) {
        this.useSpelInvoker = useSpelInvoker;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.messageHandlerMethodFactory.setBeanFactory(beanFactory);
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            BeanExpressionResolver beanExpressionResolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            if (beanExpressionResolver != null) {
                this.resolver = beanExpressionResolver;
            }
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        super.setConversionService(conversionService);
        if (conversionService != null) {
            this.messageHandlerMethodFactory.setConversionService(conversionService);
        }
    }

    public T process(Message<?> message) throws Exception {
        ParametersWrapper parameters = new ParametersWrapper(message);
        return this.processInternal(parameters);
    }

    public T process(Collection<Message<?>> messages, Map<String, Object> headers) throws Exception {
        ParametersWrapper parameters = new ParametersWrapper(messages, headers);
        return this.processInternal(parameters);
    }

    public String toString() {
        return this.displayString;
    }

    public void start() {
        if (this.targetObject instanceof Lifecycle) {
            ((Lifecycle)this.targetObject).start();
        }
    }

    public void stop() {
        if (this.targetObject instanceof Lifecycle) {
            ((Lifecycle)this.targetObject).stop();
        }
    }

    public boolean isRunning() {
        return !(this.targetObject instanceof Lifecycle) || ((Lifecycle)this.targetObject).isRunning();
    }

    private MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, String methodName, Class<?> expectedType, boolean canProcessMessageList) {
        JsonObjectMapper<?, ?> mapper;
        this.annotationType = annotationType;
        this.methodName = methodName;
        this.canProcessMessageList = canProcessMessageList;
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.expectedType = expectedType != null ? TypeDescriptor.valueOf(expectedType) : null;
        this.targetObject = targetObject;
        Map<String, Map<Class<?>, HandlerMethod>> handlerMethodsForTarget = this.findHandlerMethodsForTarget(targetObject, annotationType, methodName, expectedType != null);
        Map<Class<?>, HandlerMethod> handlerMethods = handlerMethodsForTarget.get(CANDIDATE_METHODS);
        Map<Class<?>, HandlerMethod> handlerMessageMethods = handlerMethodsForTarget.get(CANDIDATE_MESSAGE_METHODS);
        if (handlerMethods.size() == 1 && handlerMessageMethods.isEmpty() || handlerMessageMethods.size() == 1 && handlerMethods.isEmpty()) {
            this.handlerMethod = handlerMethods.size() == 1 ? handlerMethods.values().iterator().next() : handlerMessageMethods.values().iterator().next();
            this.handlerMethods = null;
            this.handlerMessageMethods = null;
            this.handlerMethodsList = null;
        } else {
            this.handlerMethod = null;
            this.handlerMethods = handlerMethods;
            this.handlerMessageMethods = handlerMessageMethods;
            this.handlerMethodsList = new LinkedList();
            this.handlerMethodsList.add(this.handlerMethods);
            this.handlerMethodsList.add(this.handlerMessageMethods);
        }
        this.setDisplayString(targetObject, methodName);
        try {
            mapper = JsonObjectMapperProvider.newInstance();
        }
        catch (IllegalStateException e) {
            mapper = null;
        }
        this.jsonObjectMapper = mapper;
    }

    private void setDisplayString(Object targetObject, Object targetMethod) {
        StringBuilder sb = new StringBuilder(targetObject.getClass().getName());
        if (targetMethod instanceof Method) {
            sb.append(".").append(((Method)targetMethod).getName());
        } else if (targetMethod instanceof String) {
            sb.append(".").append(targetMethod);
        }
        this.displayString = sb.toString() + "]";
    }

    private void prepareEvaluationContext() throws Exception {
        StandardEvaluationContext context = this.getEvaluationContext(false);
        Class targetType = AopUtils.getTargetClass((Object)this.targetObject);
        if (this.method != null) {
            context.registerMethodFilter(targetType, (MethodFilter)new FixedMethodFilter(this.method));
            if (this.expectedType != null) {
                Assert.state((boolean)context.getTypeConverter().canConvert(TypeDescriptor.valueOf(this.method.getReturnType()), this.expectedType), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + this.method));
            }
        } else {
            AnnotatedMethodFilter filter = new AnnotatedMethodFilter(this.annotationType, this.methodName, this.requiresReply);
            Assert.state((boolean)this.canReturnExpectedType(filter, targetType, context.getTypeConverter()), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + this.method));
            context.registerMethodFilter(targetType, (MethodFilter)filter);
        }
        context.setVariable("target", this.targetObject);
        context.registerFunction("requiredHeader", ParametersWrapper.class.getDeclaredMethod("getHeader", Map.class, String.class));
    }

    private boolean canReturnExpectedType(AnnotatedMethodFilter filter, Class<?> targetType, TypeConverter typeConverter) {
        if (this.expectedType == null) {
            return true;
        }
        List<Method> methods = filter.filter(Arrays.asList(ReflectionUtils.getAllDeclaredMethods(targetType)));
        for (Method method : methods) {
            if (!typeConverter.canConvert(TypeDescriptor.valueOf(method.getReturnType()), this.expectedType)) continue;
            return true;
        }
        return false;
    }

    private T processInternal(ParametersWrapper parameters) throws Exception {
        HandlerMethod candidate;
        if (!this.initialized) {
            this.initialize();
        }
        if ((candidate = this.findHandlerMethodForParameters(parameters)) == null) {
            candidate = this.defaultHandlerMethod;
        }
        Assert.notNull((Object)candidate, (String)"No candidate methods found for messages.");
        if (!candidate.initialized) {
            this.initializeHandler(candidate);
        }
        Expression expression = candidate.expression;
        T result = this.useSpelInvoker || candidate.spelOnly ? this.invokeExpression(expression, parameters) : this.invokeHandlerMethod(candidate, parameters);
        if (result != null && this.expectedType != null) {
            return (T)this.getEvaluationContext(true).getTypeConverter().convertValue(result, TypeDescriptor.forObject(result), this.expectedType);
        }
        return result;
    }

    private void initializeHandler(HandlerMethod candidate) {
        String compilerMode;
        ExpressionParser parser = candidate.useSpelInvoker == null ? EXPRESSION_PARSER_DEFAULT : (!StringUtils.hasText((String)(compilerMode = this.resolveExpression(candidate.useSpelInvoker.compilerMode(), "UseSpelInvoker.compilerMode:").toUpperCase())) ? EXPRESSION_PARSER_DEFAULT : SPEL_COMPILERS.get(SpelCompilerMode.valueOf((String)compilerMode)));
        candidate.expression = parser.parseExpression(candidate.expressionString);
        candidate.initialized = true;
    }

    private synchronized void initialize() throws Exception {
        if (!this.initialized) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null && beanFactory.containsBean("integrationArgumentResolverMessageConverter")) {
                try {
                    MessageConverter messageConverter = (MessageConverter)beanFactory.getBean("integrationArgumentResolverMessageConverter", MessageConverter.class);
                    this.messageHandlerMethodFactory.setMessageConverter(messageConverter);
                    HandlerMethodArgumentResolversHolder handlerMethodArgumentResolversHolder = (HandlerMethodArgumentResolversHolder)beanFactory.getBean(this.canProcessMessageList ? "integrationListArgumentResolvers" : "integrationArgumentResolvers", HandlerMethodArgumentResolversHolder.class);
                    this.messageHandlerMethodFactory.setCustomArgumentResolvers(handlerMethodArgumentResolversHolder.getResolvers());
                }
                catch (NoSuchBeanDefinitionException e) {
                    this.configureLocalMessageHandlerFactory();
                }
            } else {
                this.configureLocalMessageHandlerFactory();
            }
            this.messageHandlerMethodFactory.afterPropertiesSet();
            this.prepareEvaluationContext();
            this.initialized = true;
        }
    }

    private void configureLocalMessageHandlerFactory() {
        PayloadExpressionArgumentResolver payloadExpressionArgumentResolver = new PayloadExpressionArgumentResolver();
        payloadExpressionArgumentResolver.setBeanFactory(this.getBeanFactory());
        PayloadsArgumentResolver payloadsArgumentResolver = new PayloadsArgumentResolver();
        payloadsArgumentResolver.setBeanFactory(this.getBeanFactory());
        MapArgumentResolver mapArgumentResolver = new MapArgumentResolver();
        mapArgumentResolver.setBeanFactory(this.getBeanFactory());
        LinkedList<AbstractExpressionEvaluator> customArgumentResolvers = new LinkedList<AbstractExpressionEvaluator>();
        customArgumentResolvers.add(payloadExpressionArgumentResolver);
        customArgumentResolvers.add(payloadsArgumentResolver);
        if (this.canProcessMessageList) {
            CollectionArgumentResolver collectionArgumentResolver = new CollectionArgumentResolver(true);
            collectionArgumentResolver.setBeanFactory(this.getBeanFactory());
            customArgumentResolvers.add(collectionArgumentResolver);
        }
        customArgumentResolvers.add(mapArgumentResolver);
        this.messageHandlerMethodFactory.setCustomArgumentResolvers(customArgumentResolvers);
        if (this.getBeanFactory() != null && this.getBeanFactory().containsBean("integrationArgumentResolverMessageConverter")) {
            this.messageHandlerMethodFactory.setMessageConverter((MessageConverter)this.getBeanFactory().getBean("integrationArgumentResolverMessageConverter", MessageConverter.class));
        }
    }

    private T invokeHandlerMethod(HandlerMethod handlerMethod, ParametersWrapper parameters) throws Exception {
        try {
            return handlerMethod.invoke(parameters);
        }
        catch (IllegalStateException | MessageConversionException | MethodArgumentResolutionException e) {
            if (e instanceof MessageConversionException ? e.getCause() instanceof ConversionFailedException && !(e.getCause().getCause() instanceof ConverterNotFoundException) : e instanceof IllegalStateException && (!(e.getCause() instanceof IllegalArgumentException) || !e.getStackTrace()[0].getClassName().equals(InvocableHandlerMethod.class.getName()) || !"argument type mismatch".equals(e.getCause().getMessage()) && !e.getCause().getMessage().startsWith("java.lang.ClassCastException@"))) {
                throw e;
            }
            Expression expression = handlerMethod.expression;
            if (++handlerMethod.failedAttempts >= 100) {
                handlerMethod.spelOnly = true;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Failed to invoke [ " + handlerMethod.invocableHandlerMethod + "] with provided arguments [ " + parameters + " ]. \nFalling back to SpEL invocation for expression [ " + expression.getExpressionString() + " ]"));
                }
            }
            return this.invokeExpression(expression, parameters);
        }
    }

    private T invokeExpression(Expression expression, ParametersWrapper parameters) throws Exception {
        try {
            this.convertJsonPayloadIfNecessary(parameters);
            return (T)this.evaluateExpression(expression, (Object)parameters);
        }
        catch (Exception e) {
            Throwable evaluationException = e;
            if ((e instanceof EvaluationException || e instanceof MessageHandlingException) && e.getCause() != null) {
                evaluationException = e.getCause();
            }
            if (evaluationException instanceof Exception) {
                throw evaluationException;
            }
            throw new IllegalStateException("Cannot process message", evaluationException);
        }
    }

    private void convertJsonPayloadIfNecessary(ParametersWrapper parameters) {
        block6: {
            if (parameters.message != null && this.handlerMethod != null && this.handlerMethod.exclusiveMethodParameter != null && this.jsonObjectMapper != null) {
                Class type = this.handlerMethod.targetParameterType;
                if ((parameters.getPayload() instanceof String && !type.equals(String.class) || parameters.getPayload() instanceof byte[] && !type.equals(byte[].class)) && this.contentTypeIsJson(parameters.message)) {
                    try {
                        Object targetPayload = this.jsonObjectMapper.fromJson(parameters.getPayload(), type);
                        if (this.handlerMethod.targetParameterTypeDescriptor.isAssignableTo(messageTypeDescriptor)) {
                            parameters.message = this.getMessageBuilderFactory().withPayload(targetPayload).copyHeaders(parameters.getHeaders()).build();
                        } else {
                            parameters.payload = targetPayload;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug((Object)"Failed to convert from JSON", (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean contentTypeIsJson(Message<?> message) {
        Object contentType = message.getHeaders().get((Object)"contentType");
        return contentType != null && contentType.toString().contains("json");
    }

    private Map<String, Map<Class<?>, HandlerMethod>> findHandlerMethodsForTarget(Object targetObject, Class<? extends Annotation> annotationType, String methodName, boolean requiresReply) {
        HashMap handlerMethods = new HashMap();
        HashMap candidateMethods = new HashMap();
        HashMap candidateMessageMethods = new HashMap();
        HashMap fallbackMethods = new HashMap();
        HashMap fallbackMessageMethods = new HashMap();
        AtomicReference ambiguousFallbackType = new AtomicReference();
        AtomicReference ambiguousFallbackMessageGenericType = new AtomicReference();
        Class<?> targetClass = this.getTargetClass(targetObject);
        UniqueMethodFilter methodFilter = new UniqueMethodFilter(targetClass);
        ReflectionUtils.doWithMethods(targetClass, method1 -> {
            HandlerMethod handlerMethod1;
            boolean matchesAnnotation = false;
            if (method1.isBridge()) {
                return;
            }
            if (MessagingMethodInvokerHelper.isMethodDefinedOnObjectClass(method1)) {
                return;
            }
            if (method1.getDeclaringClass().equals(Proxy.class)) {
                return;
            }
            if (annotationType != null && AnnotationUtils.findAnnotation((Method)method1, (Class)annotationType) != null) {
                matchesAnnotation = true;
            } else if (!Modifier.isPublic(method1.getModifiers())) {
                return;
            }
            if (requiresReply && Void.TYPE.equals(method1.getReturnType())) {
                return;
            }
            if (methodName != null && !methodName.equals(method1.getName())) {
                return;
            }
            if (methodName == null && ObjectUtils.containsElement((Object[])new String[]{"start", "stop", "isRunning"}, (Object)method1.getName())) {
                return;
            }
            try {
                method1 = AopUtils.selectInvocableMethod((Method)method1, (Class)org.springframework.util.ClassUtils.getUserClass((Object)targetObject));
                InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(targetObject, method1);
                handlerMethod1 = new HandlerMethod(invocableHandlerMethod, this.canProcessMessageList);
                this.checkSpelInvokerRequired(targetClass, method1, handlerMethod1);
            }
            catch (IneligibleMethodException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method [" + method1 + "] is not eligible for Message handling " + e.getMessage() + "."));
                }
                return;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method [" + method1 + "] is not eligible for Message handling."), (Throwable)e);
                }
                return;
            }
            if (AnnotationUtils.getAnnotation((Method)method1, Default.class) != null) {
                Assert.state((this.defaultHandlerMethod == null ? 1 : 0) != 0, () -> "Only one method can be @Default, but there are more for: " + targetObject);
                this.defaultHandlerMethod = handlerMethod1;
            }
            Class<?> targetParameterType = handlerMethod1.getTargetParameterType();
            if (matchesAnnotation || annotationType == null) {
                if (handlerMethod1.isMessageMethod()) {
                    if (candidateMessageMethods.containsKey(targetParameterType)) {
                        throw new IllegalArgumentException("Found more than one method match for type [Message<" + targetParameterType + ">]");
                    }
                    candidateMessageMethods.put(targetParameterType, handlerMethod1);
                } else {
                    if (candidateMethods.containsKey(targetParameterType)) {
                        String exceptionMessage = "Found more than one method match for ";
                        exceptionMessage = Void.class.equals(targetParameterType) ? exceptionMessage + "empty parameter for 'payload'" : exceptionMessage + "type [" + targetParameterType + "]";
                        throw new IllegalArgumentException(exceptionMessage);
                    }
                    candidateMethods.put(targetParameterType, handlerMethod1);
                }
            } else if (handlerMethod1.isMessageMethod()) {
                if (fallbackMessageMethods.containsKey(targetParameterType)) {
                    ambiguousFallbackMessageGenericType.compareAndSet(null, targetParameterType);
                }
                fallbackMessageMethods.put(targetParameterType, handlerMethod1);
            } else {
                if (fallbackMethods.containsKey(targetParameterType)) {
                    ambiguousFallbackType.compareAndSet(null, targetParameterType);
                }
                fallbackMethods.put(targetParameterType, handlerMethod1);
            }
        }, (ReflectionUtils.MethodFilter)methodFilter);
        if (candidateMethods.isEmpty() && candidateMessageMethods.isEmpty() && fallbackMethods.isEmpty() && fallbackMessageMethods.isEmpty()) {
            this.findSingleSpecifMethodOnInterfacesIfProxy(targetObject, methodName, candidateMessageMethods, candidateMethods);
        }
        if (!candidateMethods.isEmpty() || !candidateMessageMethods.isEmpty()) {
            handlerMethods.put(CANDIDATE_METHODS, candidateMethods);
            handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
            return handlerMethods;
        }
        if ((ambiguousFallbackType.get() != null || ambiguousFallbackMessageGenericType.get() != null) && ServiceActivator.class.equals(annotationType)) {
            Class[] allInterfaces;
            ArrayList<Method> frameworkMethods = new ArrayList<Method>();
            for (Class iface : allInterfaces = org.springframework.util.ClassUtils.getAllInterfacesForClass(targetClass)) {
                try {
                    if (!"org.springframework.integration.gateway.RequestReplyExchanger".equals(iface.getName())) continue;
                    frameworkMethods.add(targetClass.getMethod("exchange", Message.class));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(targetObject.getClass() + ": Ambiguous fallback methods; using RequestReplyExchanger.exchange()"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (frameworkMethods.size() == 1) {
                Method method = org.springframework.util.ClassUtils.getMostSpecificMethod((Method)((Method)frameworkMethods.get(0)), targetObject.getClass());
                InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(targetObject, method);
                HandlerMethod handlerMethod = new HandlerMethod(invocableHandlerMethod, this.canProcessMessageList);
                this.checkSpelInvokerRequired(targetClass, method, handlerMethod);
                handlerMethods.put(CANDIDATE_METHODS, Collections.singletonMap(Object.class, handlerMethod));
                handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
                return handlerMethods;
            }
        }
        Assert.state((!fallbackMethods.isEmpty() || !fallbackMessageMethods.isEmpty() ? 1 : 0) != 0, (String)("Target object of type [" + this.targetObject.getClass() + "] has no eligible methods for handling Messages."));
        Assert.isNull(ambiguousFallbackType.get(), (String)("Found ambiguous parameter type [" + ambiguousFallbackType + "] for method match: " + fallbackMethods.values()));
        Assert.isNull(ambiguousFallbackMessageGenericType.get(), (String)("Found ambiguous parameter type [" + ambiguousFallbackMessageGenericType + "] for method match: " + fallbackMethods.values()));
        handlerMethods.put(CANDIDATE_METHODS, fallbackMethods);
        handlerMethods.put(CANDIDATE_MESSAGE_METHODS, fallbackMessageMethods);
        return handlerMethods;
    }

    private void findSingleSpecifMethodOnInterfacesIfProxy(Object targetObject, String methodName, Map<Class<?>, HandlerMethod> candidateMessageMethods, Map<Class<?>, HandlerMethod> candidateMethods) {
        if (AopUtils.isAopProxy((Object)targetObject)) {
            Class[] interfaces;
            AtomicReference targetMethod = new AtomicReference();
            AtomicReference targetClass = new AtomicReference();
            for (Class clazz : interfaces = ((Advised)targetObject).getProxiedInterfaces()) {
                ReflectionUtils.doWithMethods((Class)clazz, method1 -> {
                    if (targetMethod.get() != null) {
                        throw new IllegalStateException("Ambiguous method " + methodName + " on " + targetObject);
                    }
                    targetMethod.set(method1);
                    targetClass.set(clazz);
                }, method12 -> method12.getName().equals(methodName));
            }
            Method theMethod = (Method)targetMethod.get();
            if (theMethod != null) {
                theMethod = org.springframework.util.ClassUtils.getMostSpecificMethod((Method)theMethod, targetObject.getClass());
                InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(targetObject, theMethod);
                HandlerMethod handlerMethod = new HandlerMethod(invocableHandlerMethod, this.canProcessMessageList);
                this.checkSpelInvokerRequired((Class)targetClass.get(), theMethod, handlerMethod);
                Class<?> targetParameterType = handlerMethod.getTargetParameterType();
                if (handlerMethod.isMessageMethod()) {
                    if (candidateMessageMethods.containsKey(targetParameterType)) {
                        throw new IllegalArgumentException("Found more than one method match for type [Message<" + targetParameterType + ">]");
                    }
                    candidateMessageMethods.put(targetParameterType, handlerMethod);
                } else {
                    if (candidateMethods.containsKey(targetParameterType)) {
                        String exceptionMessage = "Found more than one method match for ";
                        exceptionMessage = Void.class.equals(targetParameterType) ? exceptionMessage + "empty parameter for 'payload'" : exceptionMessage + "type [" + targetParameterType + "]";
                        throw new IllegalArgumentException(exceptionMessage);
                    }
                    candidateMethods.put(targetParameterType, handlerMethod);
                }
            }
        }
    }

    private void checkSpelInvokerRequired(Class<?> targetClass, Method methodArg, HandlerMethod handlerMethod) {
        Method method = AopUtils.getMostSpecificMethod((Method)methodArg, targetClass);
        UseSpelInvoker useSpel = (UseSpelInvoker)AnnotationUtils.findAnnotation((Method)method, UseSpelInvoker.class);
        if (useSpel == null) {
            useSpel = (UseSpelInvoker)AnnotationUtils.findAnnotation(targetClass, UseSpelInvoker.class);
        }
        if (useSpel != null) {
            handlerMethod.spelOnly = true;
            handlerMethod.useSpelInvoker = useSpel;
        }
    }

    private String resolveExpression(String value, String msg) {
        String resolvedValue = this.resolve(value);
        if (!resolvedValue.startsWith("#{") || !value.endsWith("}")) {
            return resolvedValue;
        }
        Object evaluated = this.resolver.evaluate(resolvedValue, this.expressionContext);
        Assert.isInstanceOf(String.class, (Object)evaluated, (String)msg);
        return (String)evaluated;
    }

    private String resolve(String value) {
        if (this.getBeanFactory() != null && this.getBeanFactory() instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.getBeanFactory()).resolveEmbeddedValue(value);
        }
        return value;
    }

    private Class<?> getTargetClass(Object targetObject) {
        Class superClass;
        Class targetClass = targetObject.getClass();
        if (AopUtils.isAopProxy((Object)targetObject)) {
            targetClass = AopUtils.getTargetClass((Object)targetObject);
            if (targetClass == targetObject.getClass()) {
                try {
                    Class[] interfaces = ((Advised)targetObject).getProxiedInterfaces();
                    if (interfaces != null && interfaces.length == 1) {
                        targetClass = interfaces[0];
                    }
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Exception trying to extract interface", (Throwable)e);
                    }
                }
            }
        } else if ((org.springframework.util.ClassUtils.isCglibProxyClass(targetClass) || targetClass.getSimpleName().contains("$MockitoMock$")) && !Object.class.equals(superClass = targetObject.getClass().getSuperclass())) {
            targetClass = superClass;
        }
        return targetClass;
    }

    private HandlerMethod findHandlerMethodForParameters(ParametersWrapper parameters) {
        if (this.handlerMethod != null) {
            return this.handlerMethod;
        }
        Class<?> payloadType = parameters.getFirstParameterType();
        HandlerMethod closestMatch = this.findClosestMatch(payloadType);
        if (closestMatch != null) {
            return closestMatch;
        }
        if (Iterable.class.isAssignableFrom(payloadType) && this.handlerMethods.containsKey(Iterator.class)) {
            return this.handlerMethods.get(Iterator.class);
        }
        return this.handlerMethods.get(Void.class);
    }

    private HandlerMethod findClosestMatch(Class<?> payloadType) {
        for (Map<Class<?>, HandlerMethod> handlerMethods : this.handlerMethodsList) {
            Set<Class<?>> candidates = handlerMethods.keySet();
            Class<?> match = null;
            if (!CollectionUtils.isEmpty(candidates)) {
                match = ClassUtils.findClosestMatch(payloadType, candidates, true);
            }
            if (match == null) continue;
            return handlerMethods.get(match);
        }
        return null;
    }

    private static boolean isMethodDefinedOnObjectClass(Method method) {
        return method != null && (method.getDeclaringClass().equals(Object.class) || ReflectionUtils.isEqualsMethod((Method)method) || ReflectionUtils.isHashCodeMethod((Method)method) || ReflectionUtils.isToStringMethod((Method)method) || AopUtils.isFinalizeMethod((Method)method) || method.getName().equals("clone") && method.getParameterTypes().length == 0);
    }

    static {
        SPEL_COMPILERS.put(SpelCompilerMode.OFF, EXPRESSION_PARSER_OFF);
        SPEL_COMPILERS.put(SpelCompilerMode.IMMEDIATE, EXPRESSION_PARSER_IMMEDIATE);
        SPEL_COMPILERS.put(SpelCompilerMode.MIXED, EXPRESSION_PARSER_MIXED);
    }

    private static final class IneligibleMethodException
    extends RuntimeException {
        IneligibleMethodException(String message) {
            super(message);
        }
    }

    public static class ParametersWrapper {
        private final Collection<Message<?>> messages;
        private final Map<String, Object> headers;
        private Message<?> message;
        private Object payload;

        ParametersWrapper(Message<?> message) {
            this.message = message;
            this.payload = message.getPayload();
            this.headers = message.getHeaders();
            this.messages = null;
        }

        ParametersWrapper(Collection<Message<?>> messages, Map<String, Object> headers) {
            this.messages = messages;
            this.headers = headers;
        }

        public static Object getHeader(Map<?, ?> headers, String header) {
            Object object = headers.get(header);
            if (object == null) {
                throw new IllegalArgumentException("required header not available: " + header);
            }
            return object;
        }

        public Object getPayload() {
            Assert.state((this.payload != null ? 1 : 0) != 0, (String)"Invalid method parameter for payload: was expecting collection.");
            return this.payload;
        }

        public Collection<Message<?>> getMessages() {
            Assert.state((this.messages != null ? 1 : 0) != 0, (String)"Invalid method parameter for messages: was expecting a single payload.");
            return this.messages;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public Class<?> getFirstParameterType() {
            if (this.payload != null) {
                return this.payload.getClass();
            }
            return this.messages.getClass();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ParametersWrapper{");
            if (this.messages != null) {
                sb.append("messages=").append(this.messages).append(", headers=").append(this.headers);
            } else {
                sb.append("message=").append(this.message);
            }
            return sb.append('}').toString();
        }
    }

    private static class HandlerMethod {
        private final String expressionString;
        private final InvocableHandlerMethod invocableHandlerMethod;
        private final boolean canProcessMessageList;
        private volatile Expression expression;
        private volatile TypeDescriptor targetParameterTypeDescriptor;
        private volatile Class<?> targetParameterType = Void.class;
        private MethodParameter exclusiveMethodParameter;
        private volatile boolean messageMethod;
        private volatile boolean spelOnly;
        private volatile UseSpelInvoker useSpelInvoker;
        private volatile boolean initialized;
        private volatile int failedAttempts = 0;

        HandlerMethod(InvocableHandlerMethod invocableHandlerMethod, boolean canProcessMessageList) {
            this.invocableHandlerMethod = invocableHandlerMethod;
            this.canProcessMessageList = canProcessMessageList;
            this.expressionString = this.generateExpression(this.invocableHandlerMethod.getMethod());
        }

        public <T> T invoke(ParametersWrapper parameters) throws Exception {
            Message<?> message = parameters.getMessage();
            if (this.canProcessMessageList) {
                message = new MutableMessage(parameters.getMessages(), parameters.getHeaders());
            }
            return (T)this.invocableHandlerMethod.invoke(message, new Object[0]);
        }

        Class<?> getTargetParameterType() {
            return this.targetParameterType;
        }

        private boolean isMessageMethod() {
            return this.messageMethod;
        }

        public String toString() {
            return this.invocableHandlerMethod.toString();
        }

        private String generateExpression(Method method) {
            StringBuilder sb = new StringBuilder("#target." + method.getName() + "(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            boolean hasUnqualifiedMapParameter = false;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                MethodParameter methodParameter = new MethodParameter(method, i);
                TypeDescriptor parameterTypeDescriptor = new TypeDescriptor(methodParameter);
                Class parameterType = parameterTypeDescriptor.getObjectType();
                Annotation mappingAnnotation = MessagingAnnotationUtils.findMessagePartAnnotation(parameterAnnotations[i], true);
                if (mappingAnnotation != null) {
                    String qualifierExpression;
                    Class<? extends Annotation> annotationType = mappingAnnotation.annotationType();
                    if (annotationType.equals(Payload.class)) {
                        sb.append("payload");
                        qualifierExpression = (String)AnnotationUtils.getValue((Annotation)mappingAnnotation);
                        if (StringUtils.hasText((String)qualifierExpression)) {
                            sb.append(".").append(qualifierExpression);
                        }
                        if (!StringUtils.hasText((String)qualifierExpression)) {
                            this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                        }
                    }
                    if (annotationType.equals(Payloads.class)) {
                        Assert.isTrue((boolean)this.canProcessMessageList, (String)"The @Payloads annotation can only be applied if method handler canProcessMessageList.");
                        Assert.isTrue((boolean)Collection.class.isAssignableFrom(parameterType), (String)"The @Payloads annotation can only be applied to a Collection-typed parameter.");
                        sb.append("messages.![payload");
                        qualifierExpression = ((Payloads)mappingAnnotation).value();
                        if (StringUtils.hasText((String)qualifierExpression)) {
                            sb.append(".").append(qualifierExpression);
                        }
                        sb.append("]");
                        if (StringUtils.hasText((String)qualifierExpression)) continue;
                        this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                        continue;
                    }
                    if (annotationType.equals(Headers.class)) {
                        Assert.isTrue((boolean)Map.class.isAssignableFrom(parameterType), (String)"The @Headers annotation can only be applied to a Map-typed parameter.");
                        sb.append("headers");
                        continue;
                    }
                    if (!annotationType.equals(Header.class)) continue;
                    sb.append(this.determineHeaderExpression(mappingAnnotation, methodParameter));
                    continue;
                }
                if (parameterTypeDescriptor.isAssignableTo(messageTypeDescriptor)) {
                    this.messageMethod = true;
                    sb.append("message");
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (this.canProcessMessageList && (parameterTypeDescriptor.isAssignableTo(messageListTypeDescriptor) || parameterTypeDescriptor.isAssignableTo(messageArrayTypeDescriptor))) {
                    sb.append("messages");
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Collection.class.isAssignableFrom(parameterType) || parameterType.isArray()) {
                    if (this.canProcessMessageList) {
                        sb.append("messages.![payload]");
                    } else {
                        sb.append("payload");
                    }
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Iterator.class.isAssignableFrom(parameterType)) {
                    if (this.canProcessMessageList) {
                        Type type = method.getGenericParameterTypes()[i];
                        Type parameterizedType = null;
                        if (type instanceof ParameterizedType && (parameterizedType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                            parameterizedType = ((ParameterizedType)parameterizedType).getRawType();
                        }
                        if (parameterizedType != null && Message.class.isAssignableFrom((Class)parameterizedType)) {
                            sb.append("messages.iterator()");
                        } else {
                            sb.append("messages.![payload].iterator()");
                        }
                    } else {
                        sb.append("payload.iterator()");
                    }
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Map.class.isAssignableFrom(parameterType)) {
                    if (Properties.class.isAssignableFrom(parameterType)) {
                        sb.append("payload instanceof T(java.util.Map) or (payload instanceof T(String) and payload.contains('=')) ? payload : headers");
                    } else {
                        sb.append("(payload instanceof T(java.util.Map) ? payload : headers)");
                    }
                    Assert.isTrue((!hasUnqualifiedMapParameter ? 1 : 0) != 0, (String)"Found more than one Map typed parameter without any qualification. Consider using @Payload or @Headers on at least one of the parameters.");
                    hasUnqualifiedMapParameter = true;
                    continue;
                }
                sb.append("payload");
                this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
            }
            if (hasUnqualifiedMapParameter && this.targetParameterType != null && Map.class.isAssignableFrom(this.targetParameterType)) {
                throw new IllegalArgumentException("Unable to determine payload matching parameter due to ambiguous Map typed parameters. Consider adding the @Payload and or @Headers annotations as appropriate.");
            }
            sb.append(")");
            if (this.targetParameterTypeDescriptor == null) {
                this.targetParameterTypeDescriptor = TypeDescriptor.valueOf(Void.class);
            }
            return sb.toString();
        }

        private String determineHeaderExpression(Annotation headerAnnotation, MethodParameter methodParameter) {
            methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            String headerName = null;
            String relativeExpression = "";
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)AnnotationUtils.getAnnotationAttributes((Annotation)headerAnnotation);
            String valueAttribute = annotationAttributes.getString("value");
            if (!StringUtils.hasText((String)valueAttribute)) {
                headerName = methodParameter.getParameterName();
            } else if (valueAttribute.indexOf(46) != -1) {
                String[] tokens = valueAttribute.split("\\.", 2);
                headerName = tokens[0];
                if (StringUtils.hasText((String)tokens[1])) {
                    relativeExpression = "." + tokens[1];
                    this.spelOnly = true;
                }
            } else {
                headerName = valueAttribute;
            }
            Assert.notNull((Object)headerName, (String)"Cannot determine header name. Possible reasons: -debug is disabled or header name is not explicitly provided via @Header annotation.");
            String headerRetrievalExpression = "headers['" + headerName + "']";
            String fullHeaderExpression = headerRetrievalExpression + relativeExpression;
            if (annotationAttributes.getBoolean("required") && !methodParameter.getParameterType().equals(Optional.class)) {
                return "#requiredHeader(headers, '" + headerName + "')" + relativeExpression;
            }
            if (!StringUtils.hasLength((String)relativeExpression)) {
                return headerRetrievalExpression + " ?: null";
            }
            return headerRetrievalExpression + " != null ? " + fullHeaderExpression + " : null";
        }

        private void setExclusiveTargetParameterType(TypeDescriptor targetParameterType, MethodParameter methodParameter) {
            if (this.targetParameterTypeDescriptor != null) {
                throw new IneligibleMethodException("Found more than one parameter type candidate: [" + this.targetParameterTypeDescriptor + "] and [" + targetParameterType + "]");
            }
            this.targetParameterTypeDescriptor = targetParameterType;
            this.targetParameterType = Message.class.isAssignableFrom(targetParameterType.getObjectType()) ? methodParameter.nested().getNestedParameterType() : targetParameterType.getObjectType();
            this.exclusiveMethodParameter = methodParameter;
        }
    }
}

