/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.net.URL;
import java.util.List;
import org.springframework.security.oauth2.core.ClaimAccessor;

public interface OAuth2AuthorizationServerMetadataClaimAccessor
extends ClaimAccessor {
    default public URL getIssuer() {
        return this.getClaimAsURL("issuer");
    }

    default public URL getAuthorizationEndpoint() {
        return this.getClaimAsURL("authorization_endpoint");
    }

    default public URL getDeviceAuthorizationEndpoint() {
        return this.getClaimAsURL("device_authorization_endpoint");
    }

    default public URL getTokenEndpoint() {
        return this.getClaimAsURL("token_endpoint");
    }

    default public List<String> getTokenEndpointAuthenticationMethods() {
        return this.getClaimAsStringList("token_endpoint_auth_methods_supported");
    }

    default public URL getJwkSetUrl() {
        return this.getClaimAsURL("jwks_uri");
    }

    default public List<String> getScopes() {
        return this.getClaimAsStringList("scopes_supported");
    }

    default public List<String> getResponseTypes() {
        return this.getClaimAsStringList("response_types_supported");
    }

    default public List<String> getGrantTypes() {
        return this.getClaimAsStringList("grant_types_supported");
    }

    default public URL getTokenRevocationEndpoint() {
        return this.getClaimAsURL("revocation_endpoint");
    }

    default public List<String> getTokenRevocationEndpointAuthenticationMethods() {
        return this.getClaimAsStringList("revocation_endpoint_auth_methods_supported");
    }

    default public URL getTokenIntrospectionEndpoint() {
        return this.getClaimAsURL("introspection_endpoint");
    }

    default public List<String> getTokenIntrospectionEndpointAuthenticationMethods() {
        return this.getClaimAsStringList("introspection_endpoint_auth_methods_supported");
    }

    default public URL getClientRegistrationEndpoint() {
        return this.getClaimAsURL("registration_endpoint");
    }

    default public List<String> getCodeChallengeMethods() {
        return this.getClaimAsStringList("code_challenge_methods_supported");
    }
}

