/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import com.nimbusds.jwt.JWTParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.util.Assert;

public final class JwtIssuerAuthenticationManagerResolver
implements AuthenticationManagerResolver<HttpServletRequest> {
    private final AuthenticationManager authenticationManager;

    public JwtIssuerAuthenticationManagerResolver(String ... trustedIssuers) {
        this(Arrays.asList(trustedIssuers));
    }

    public JwtIssuerAuthenticationManagerResolver(Collection<String> trustedIssuers) {
        Assert.notEmpty(trustedIssuers, (String)"trustedIssuers cannot be empty");
        this.authenticationManager = new ResolvingAuthenticationManager(new TrustedIssuerJwtAuthenticationManagerResolver(Collections.unmodifiableCollection(trustedIssuers)::contains));
    }

    public JwtIssuerAuthenticationManagerResolver(AuthenticationManagerResolver<String> issuerAuthenticationManagerResolver) {
        Assert.notNull(issuerAuthenticationManagerResolver, (String)"issuerAuthenticationManagerResolver cannot be null");
        this.authenticationManager = new ResolvingAuthenticationManager(issuerAuthenticationManagerResolver);
    }

    public AuthenticationManager resolve(HttpServletRequest request) {
        return this.authenticationManager;
    }

    static class TrustedIssuerJwtAuthenticationManagerResolver
    implements AuthenticationManagerResolver<String> {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final Map<String, AuthenticationManager> authenticationManagers = new ConcurrentHashMap<String, AuthenticationManager>();
        private final Predicate<String> trustedIssuer;

        TrustedIssuerJwtAuthenticationManagerResolver(Predicate<String> trustedIssuer) {
            this.trustedIssuer = trustedIssuer;
        }

        public AuthenticationManager resolve(String issuer) {
            if (this.trustedIssuer.test(issuer)) {
                AuthenticationManager authenticationManager = this.authenticationManagers.computeIfAbsent(issuer, k -> {
                    this.logger.debug((Object)"Constructing AuthenticationManager");
                    JwtDecoder jwtDecoder = JwtDecoders.fromIssuerLocation((String)issuer);
                    return new JwtAuthenticationProvider(jwtDecoder)::authenticate;
                });
                this.logger.debug((Object)LogMessage.format((String)"Resolved AuthenticationManager for issuer '%s'", (Object)issuer));
                return authenticationManager;
            }
            this.logger.debug((Object)"Did not resolve AuthenticationManager since issuer is not trusted");
            return null;
        }
    }

    private static class JwtClaimIssuerConverter
    implements Converter<BearerTokenAuthenticationToken, String> {
        private JwtClaimIssuerConverter() {
        }

        public String convert(@NonNull BearerTokenAuthenticationToken authentication) {
            String token = authentication.getToken();
            try {
                String issuer = JWTParser.parse((String)token).getJWTClaimsSet().getIssuer();
                if (issuer != null) {
                    return issuer;
                }
            }
            catch (Exception ex) {
                throw new InvalidBearerTokenException(ex.getMessage(), ex);
            }
            throw new InvalidBearerTokenException("Missing issuer");
        }
    }

    private static class ResolvingAuthenticationManager
    implements AuthenticationManager {
        private final Converter<BearerTokenAuthenticationToken, String> issuerConverter = new JwtClaimIssuerConverter();
        private final AuthenticationManagerResolver<String> issuerAuthenticationManagerResolver;

        ResolvingAuthenticationManager(AuthenticationManagerResolver<String> issuerAuthenticationManagerResolver) {
            this.issuerAuthenticationManagerResolver = issuerAuthenticationManagerResolver;
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            Assert.isTrue((boolean)(authentication instanceof BearerTokenAuthenticationToken), (String)"Authentication must be of type BearerTokenAuthenticationToken");
            BearerTokenAuthenticationToken token = (BearerTokenAuthenticationToken)authentication;
            String issuer = (String)this.issuerConverter.convert((Object)token);
            AuthenticationManager authenticationManager = this.issuerAuthenticationManagerResolver.resolve((Object)issuer);
            if (authenticationManager == null) {
                throw new InvalidBearerTokenException("Invalid issuer");
            }
            return authenticationManager.authenticate(authentication);
        }
    }
}

