/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.comparator.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.ReflectionComparatorFactory;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.MapDifference;

public class MapComparator
implements Comparator {
    @Override
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return left instanceof Map && right instanceof Map;
    }

    @Override
    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        Map leftMap = (Map)left;
        Map rightMap = (Map)right;
        HashMap rightCopy = new HashMap(rightMap);
        ReflectionComparator keyReflectionComparator = ReflectionComparatorFactory.createRefectionComparator(new ReflectionComparatorMode[0]);
        MapDifference difference = new MapDifference("Different elements", left, right, leftMap, rightMap);
        for (Map.Entry leftEntry : leftMap.entrySet()) {
            Object leftKey = leftEntry.getKey();
            Object leftValue = leftEntry.getValue();
            boolean found = false;
            Iterator rightIterator = rightCopy.entrySet().iterator();
            while (rightIterator.hasNext()) {
                Map.Entry rightEntry = rightIterator.next();
                Object rightKey = rightEntry.getKey();
                Object rightValue = rightEntry.getValue();
                boolean isKeyEqual = keyReflectionComparator.isEqual(leftKey, rightKey);
                if (!isKeyEqual) continue;
                found = true;
                rightIterator.remove();
                Difference elementDifference = reflectionComparator.getDifference(leftValue, rightValue, onlyFirstDifference);
                if (elementDifference == null) break;
                difference.addValueDifference(leftKey, elementDifference);
                if (!onlyFirstDifference) break;
                return difference;
            }
            if (found) continue;
            difference.addLeftMissingKey(leftKey);
        }
        for (Map.Entry rightKey : rightCopy.keySet()) {
            difference.addRightMissingKey(rightKey);
        }
        if (difference.getValueDifferences().isEmpty() && difference.getLeftMissingKeys().isEmpty() && difference.getRightMissingKeys().isEmpty()) {
            return null;
        }
        return difference;
    }
}

