/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.util;

import java.util.Map;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.reflectionassert.difference.ClassDifference;
import org.unitils.reflectionassert.difference.CollectionDifference;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.DifferenceVisitor;
import org.unitils.reflectionassert.difference.MapDifference;
import org.unitils.reflectionassert.difference.ObjectDifference;
import org.unitils.reflectionassert.difference.UnorderedCollectionDifference;

public class InnerDifferenceFinder {
    public static Difference getInnerDifference(String fieldName, Difference difference) {
        if (difference == null) {
            return null;
        }
        return difference.accept(new InnerDifferenceVisitor(), fieldName);
    }

    protected static class InnerDifferenceVisitor
    implements DifferenceVisitor<Difference, String> {
        protected ObjectFormatter objectFormatter = new ObjectFormatter();

        protected InnerDifferenceVisitor() {
        }

        @Override
        public Difference visit(Difference difference, String key) {
            return null;
        }

        @Override
        public Difference visit(ObjectDifference objectDifference, String fieldName) {
            return objectDifference.getFieldDifferences().get(fieldName);
        }

        @Override
        public Difference visit(ClassDifference classDifference, String argument) {
            return null;
        }

        @Override
        public Difference visit(MapDifference mapDifference, String keyString) {
            for (Map.Entry<Object, Difference> entry : mapDifference.getValueDifferences().entrySet()) {
                if (!this.objectFormatter.format(entry.getKey()).equals(keyString)) continue;
                return entry.getValue();
            }
            return null;
        }

        @Override
        public Difference visit(CollectionDifference collectionDifference, String indexString) {
            return collectionDifference.getElementDifferences().get(new Integer(indexString));
        }

        @Override
        public Difference visit(UnorderedCollectionDifference unorderedCollectionDifference, String indexString) {
            int leftIndex = new Integer(indexString);
            int rightIndex = unorderedCollectionDifference.getBestMatchingIndexes().get(leftIndex);
            return unorderedCollectionDifference.getElementDifference(leftIndex, rightIndex);
        }
    }
}

