/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.ConfigurableCacheStrategy;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.ServletContextPropertyWroConfigurationFactory;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.factory.ConfigurableModelFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.ConfigurableLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.support.LocatorProvider;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ConfigurableProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.support.ProcessorProvider;
import ro.isdc.wro.model.resource.support.hash.ConfigurableHashStrategy;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.ConfigurableNamingStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;

public class ConfigurableWroManagerFactory
extends BaseWroManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableWroManagerFactory.class);
    private Properties configProperties;
    private Properties additionalConfigProperties;

    protected void contributeLocators(Map<String, UriLocator> map) {
    }

    protected void contributePreProcessors(Map<String, ResourcePreProcessor> map) {
    }

    protected void contributePostProcessors(Map<String, ResourcePostProcessor> map) {
    }

    @Override
    protected UriLocatorFactory newUriLocatorFactory() {
        return new ConfigurableLocatorFactory(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "uriLocators");
                return props;
            }

            @Override
            protected Map<String, UriLocator> getStrategies(LocatorProvider provider) {
                Map<String, UriLocator> map = super.getStrategies(provider);
                ConfigurableWroManagerFactory.this.contributeLocators(map);
                return map;
            }
        };
    }

    @Override
    protected ProcessorsFactory newProcessorsFactory() {
        return new ConfigurableProcessorsFactory(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "preProcessors");
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "postProcessors");
                return props;
            }

            @Override
            protected Map<String, ResourcePostProcessor> getPostProcessorStrategies(ProcessorProvider provider) {
                Map<String, ResourcePostProcessor> map = super.getPostProcessorStrategies(provider);
                ConfigurableWroManagerFactory.this.contributePostProcessors(map);
                return map;
            }

            @Override
            protected Map<String, ResourcePreProcessor> getPreProcessorStrategies(ProcessorProvider provider) {
                Map<String, ResourcePreProcessor> map = super.getPreProcessorStrategies(provider);
                ConfigurableWroManagerFactory.this.contributePreProcessors(map);
                return map;
            }
        };
    }

    @Override
    protected NamingStrategy newNamingStrategy() {
        return new ConfigurableNamingStrategy(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "namingStrategy");
                return props;
            }
        };
    }

    @Override
    protected HashStrategy newHashStrategy() {
        return new ConfigurableHashStrategy(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "hashStrategy");
                return props;
            }
        };
    }

    @Override
    protected CacheStrategy<CacheKey, CacheValue> newCacheStrategy() {
        return new ConfigurableCacheStrategy(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "cacheStrategy");
                return props;
            }
        };
    }

    @Override
    protected WroModelFactory newModelFactory() {
        return new ConfigurableModelFactory(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "modelFactory");
                return props;
            }
        };
    }

    private void updatePropertiesWithConfiguration(Properties props, String key) {
        FilterConfig filterConfig = Context.get().getFilterConfig();
        String valuesAsString = filterConfig.getInitParameter(key);
        if (valuesAsString != null) {
            props.setProperty(key, valuesAsString);
        } else {
            String value = this.getConfigProperties().getProperty(key);
            if (value != null) {
                props.setProperty(key, value);
            }
        }
    }

    private Properties getConfigProperties() {
        if (this.configProperties == null) {
            this.configProperties = this.newConfigProperties();
            if (this.additionalConfigProperties != null) {
                this.configProperties.putAll((Map<?, ?>)this.additionalConfigProperties);
            }
        }
        return this.configProperties;
    }

    protected Properties newConfigProperties() {
        Properties props = new Properties();
        try {
            return new ServletContextPropertyWroConfigurationFactory(Context.get().getServletContext()).createProperties();
        }
        catch (Exception e) {
            LOG.warn("No configuration property file found. Using default values.", (Throwable)e);
            return props;
        }
    }

    ConfigurableWroManagerFactory addConfigProperties(Properties configProperties) {
        Validate.notNull((Object)configProperties);
        this.additionalConfigProperties = configProperties;
        return this;
    }

    ConfigurableWroManagerFactory setConfigProperties(Properties configProperties) {
        Validate.notNull((Object)configProperties);
        this.configProperties = configProperties;
        return this;
    }
}

