/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.locator;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.wildcard.DefaultWildcardStreamLocator;

public class WebjarUriLocator
implements UriLocator {
    private static final String PATTERN = ".*";
    private static final Logger LOG = LoggerFactory.getLogger(WebjarUriLocator.class);
    public static final String ALIAS = "webjar";
    public static final String PREFIX = String.format("%s:", "webjar");
    private final UriLocator classpathLocator = new ClasspathUriLocator();
    private final WebJarAssetLocator webjarAssetLocator = this.newWebJarAssetLocator();

    private WebJarAssetLocator newWebJarAssetLocator() {
        return new WebJarAssetLocator(WebJarAssetLocator.getFullPathIndex((Pattern)Pattern.compile(PATTERN), (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}));
    }

    public static String createUri(String path) {
        Validate.notNull((Object)path);
        return PREFIX + path;
    }

    public InputStream locate(String uri) throws IOException {
        LOG.debug("locating: {}", (Object)uri);
        try {
            String fullpath = this.webjarAssetLocator.getFullPath(this.extractPath(uri));
            return this.classpathLocator.locate(ClasspathUriLocator.createUri((String)fullpath));
        }
        catch (Exception e) {
            throw new IOException("No webjar with uri: " + uri + " available.", e);
        }
    }

    private String extractPath(String uri) {
        return DefaultWildcardStreamLocator.stripQueryPath((String)uri.replace(PREFIX, ""));
    }

    public boolean accept(String uri) {
        return uri.trim().startsWith(PREFIX);
    }
}

