/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnablementTypeFilter {
    ENABLED("ENABLED"),
    PENDING("PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnablementTypeFilter> VALUE_MAP;
    private final String value;

    private EnablementTypeFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnablementTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnablementTypeFilter> knownValues() {
        EnumSet<EnablementTypeFilter> knownValues = EnumSet.allOf(EnablementTypeFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnablementTypeFilter.class, EnablementTypeFilter::toString);
    }
}

