/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.VpcLink;

public class GetVpcLinksPublisher
implements SdkPublisher<GetVpcLinksResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetVpcLinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetVpcLinksPublisher(ApiGatewayAsyncClient client, GetVpcLinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetVpcLinksPublisher(ApiGatewayAsyncClient client, GetVpcLinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetVpcLinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetVpcLinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpcLink> items() {
        Function<GetVpcLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetVpcLinksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetVpcLinksResponseFetcher
    implements AsyncPageFetcher<GetVpcLinksResponse> {
        private GetVpcLinksResponseFetcher() {
        }

        public boolean hasNextPage(GetVpcLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetVpcLinksResponse> nextPage(GetVpcLinksResponse previousPage) {
            if (previousPage == null) {
                return GetVpcLinksPublisher.this.client.getVpcLinks(GetVpcLinksPublisher.this.firstRequest);
            }
            return GetVpcLinksPublisher.this.client.getVpcLinks((GetVpcLinksRequest)((Object)GetVpcLinksPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

