/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Insights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Insights> {
    private static final SdkField<Integer> ACTIVE_ASSESSMENTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("activeAssessmentsCount").getter(Insights.getter(Insights::activeAssessmentsCount)).setter(Insights.setter(Builder::activeAssessmentsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAssessmentsCount").build()}).build();
    private static final SdkField<Integer> NONCOMPLIANT_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noncompliantEvidenceCount").getter(Insights.getter(Insights::noncompliantEvidenceCount)).setter(Insights.setter(Builder::noncompliantEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noncompliantEvidenceCount").build()}).build();
    private static final SdkField<Integer> COMPLIANT_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("compliantEvidenceCount").getter(Insights.getter(Insights::compliantEvidenceCount)).setter(Insights.setter(Builder::compliantEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliantEvidenceCount").build()}).build();
    private static final SdkField<Integer> INCONCLUSIVE_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inconclusiveEvidenceCount").getter(Insights.getter(Insights::inconclusiveEvidenceCount)).setter(Insights.setter(Builder::inconclusiveEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inconclusiveEvidenceCount").build()}).build();
    private static final SdkField<Integer> ASSESSMENT_CONTROLS_COUNT_BY_NONCOMPLIANT_EVIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("assessmentControlsCountByNoncompliantEvidence").getter(Insights.getter(Insights::assessmentControlsCountByNoncompliantEvidence)).setter(Insights.setter(Builder::assessmentControlsCountByNoncompliantEvidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentControlsCountByNoncompliantEvidence").build()}).build();
    private static final SdkField<Integer> TOTAL_ASSESSMENT_CONTROLS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalAssessmentControlsCount").getter(Insights.getter(Insights::totalAssessmentControlsCount)).setter(Insights.setter(Builder::totalAssessmentControlsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalAssessmentControlsCount").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(Insights.getter(Insights::lastUpdated)).setter(Insights.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_ASSESSMENTS_COUNT_FIELD, NONCOMPLIANT_EVIDENCE_COUNT_FIELD, COMPLIANT_EVIDENCE_COUNT_FIELD, INCONCLUSIVE_EVIDENCE_COUNT_FIELD, ASSESSMENT_CONTROLS_COUNT_BY_NONCOMPLIANT_EVIDENCE_FIELD, TOTAL_ASSESSMENT_CONTROLS_COUNT_FIELD, LAST_UPDATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer activeAssessmentsCount;
    private final Integer noncompliantEvidenceCount;
    private final Integer compliantEvidenceCount;
    private final Integer inconclusiveEvidenceCount;
    private final Integer assessmentControlsCountByNoncompliantEvidence;
    private final Integer totalAssessmentControlsCount;
    private final Instant lastUpdated;

    private Insights(BuilderImpl builder) {
        this.activeAssessmentsCount = builder.activeAssessmentsCount;
        this.noncompliantEvidenceCount = builder.noncompliantEvidenceCount;
        this.compliantEvidenceCount = builder.compliantEvidenceCount;
        this.inconclusiveEvidenceCount = builder.inconclusiveEvidenceCount;
        this.assessmentControlsCountByNoncompliantEvidence = builder.assessmentControlsCountByNoncompliantEvidence;
        this.totalAssessmentControlsCount = builder.totalAssessmentControlsCount;
        this.lastUpdated = builder.lastUpdated;
    }

    public final Integer activeAssessmentsCount() {
        return this.activeAssessmentsCount;
    }

    public final Integer noncompliantEvidenceCount() {
        return this.noncompliantEvidenceCount;
    }

    public final Integer compliantEvidenceCount() {
        return this.compliantEvidenceCount;
    }

    public final Integer inconclusiveEvidenceCount() {
        return this.inconclusiveEvidenceCount;
    }

    public final Integer assessmentControlsCountByNoncompliantEvidence() {
        return this.assessmentControlsCountByNoncompliantEvidence;
    }

    public final Integer totalAssessmentControlsCount() {
        return this.totalAssessmentControlsCount;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeAssessmentsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.noncompliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inconclusiveEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentControlsCountByNoncompliantEvidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAssessmentControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insights)) {
            return false;
        }
        Insights other = (Insights)obj;
        return Objects.equals(this.activeAssessmentsCount(), other.activeAssessmentsCount()) && Objects.equals(this.noncompliantEvidenceCount(), other.noncompliantEvidenceCount()) && Objects.equals(this.compliantEvidenceCount(), other.compliantEvidenceCount()) && Objects.equals(this.inconclusiveEvidenceCount(), other.inconclusiveEvidenceCount()) && Objects.equals(this.assessmentControlsCountByNoncompliantEvidence(), other.assessmentControlsCountByNoncompliantEvidence()) && Objects.equals(this.totalAssessmentControlsCount(), other.totalAssessmentControlsCount()) && Objects.equals(this.lastUpdated(), other.lastUpdated());
    }

    public final String toString() {
        return ToString.builder((String)"Insights").add("ActiveAssessmentsCount", (Object)this.activeAssessmentsCount()).add("NoncompliantEvidenceCount", (Object)this.noncompliantEvidenceCount()).add("CompliantEvidenceCount", (Object)this.compliantEvidenceCount()).add("InconclusiveEvidenceCount", (Object)this.inconclusiveEvidenceCount()).add("AssessmentControlsCountByNoncompliantEvidence", (Object)this.assessmentControlsCountByNoncompliantEvidence()).add("TotalAssessmentControlsCount", (Object)this.totalAssessmentControlsCount()).add("LastUpdated", (Object)this.lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeAssessmentsCount": {
                return Optional.ofNullable(clazz.cast(this.activeAssessmentsCount()));
            }
            case "noncompliantEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.noncompliantEvidenceCount()));
            }
            case "compliantEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.compliantEvidenceCount()));
            }
            case "inconclusiveEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.inconclusiveEvidenceCount()));
            }
            case "assessmentControlsCountByNoncompliantEvidence": {
                return Optional.ofNullable(clazz.cast(this.assessmentControlsCountByNoncompliantEvidence()));
            }
            case "totalAssessmentControlsCount": {
                return Optional.ofNullable(clazz.cast(this.totalAssessmentControlsCount()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Insights, T> g) {
        return obj -> g.apply((Insights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer activeAssessmentsCount;
        private Integer noncompliantEvidenceCount;
        private Integer compliantEvidenceCount;
        private Integer inconclusiveEvidenceCount;
        private Integer assessmentControlsCountByNoncompliantEvidence;
        private Integer totalAssessmentControlsCount;
        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(Insights model) {
            this.activeAssessmentsCount(model.activeAssessmentsCount);
            this.noncompliantEvidenceCount(model.noncompliantEvidenceCount);
            this.compliantEvidenceCount(model.compliantEvidenceCount);
            this.inconclusiveEvidenceCount(model.inconclusiveEvidenceCount);
            this.assessmentControlsCountByNoncompliantEvidence(model.assessmentControlsCountByNoncompliantEvidence);
            this.totalAssessmentControlsCount(model.totalAssessmentControlsCount);
            this.lastUpdated(model.lastUpdated);
        }

        public final Integer getActiveAssessmentsCount() {
            return this.activeAssessmentsCount;
        }

        public final void setActiveAssessmentsCount(Integer activeAssessmentsCount) {
            this.activeAssessmentsCount = activeAssessmentsCount;
        }

        @Override
        public final Builder activeAssessmentsCount(Integer activeAssessmentsCount) {
            this.activeAssessmentsCount = activeAssessmentsCount;
            return this;
        }

        public final Integer getNoncompliantEvidenceCount() {
            return this.noncompliantEvidenceCount;
        }

        public final void setNoncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
        }

        @Override
        public final Builder noncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
            return this;
        }

        public final Integer getCompliantEvidenceCount() {
            return this.compliantEvidenceCount;
        }

        public final void setCompliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
        }

        @Override
        public final Builder compliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
            return this;
        }

        public final Integer getInconclusiveEvidenceCount() {
            return this.inconclusiveEvidenceCount;
        }

        public final void setInconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
        }

        @Override
        public final Builder inconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
            return this;
        }

        public final Integer getAssessmentControlsCountByNoncompliantEvidence() {
            return this.assessmentControlsCountByNoncompliantEvidence;
        }

        public final void setAssessmentControlsCountByNoncompliantEvidence(Integer assessmentControlsCountByNoncompliantEvidence) {
            this.assessmentControlsCountByNoncompliantEvidence = assessmentControlsCountByNoncompliantEvidence;
        }

        @Override
        public final Builder assessmentControlsCountByNoncompliantEvidence(Integer assessmentControlsCountByNoncompliantEvidence) {
            this.assessmentControlsCountByNoncompliantEvidence = assessmentControlsCountByNoncompliantEvidence;
            return this;
        }

        public final Integer getTotalAssessmentControlsCount() {
            return this.totalAssessmentControlsCount;
        }

        public final void setTotalAssessmentControlsCount(Integer totalAssessmentControlsCount) {
            this.totalAssessmentControlsCount = totalAssessmentControlsCount;
        }

        @Override
        public final Builder totalAssessmentControlsCount(Integer totalAssessmentControlsCount) {
            this.totalAssessmentControlsCount = totalAssessmentControlsCount;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Insights build() {
            return new Insights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Insights> {
        public Builder activeAssessmentsCount(Integer var1);

        public Builder noncompliantEvidenceCount(Integer var1);

        public Builder compliantEvidenceCount(Integer var1);

        public Builder inconclusiveEvidenceCount(Integer var1);

        public Builder assessmentControlsCountByNoncompliantEvidence(Integer var1);

        public Builder totalAssessmentControlsCount(Integer var1);

        public Builder lastUpdated(Instant var1);
    }
}

