/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackupJobState {
    CREATED("CREATED"),
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    ABORTING("ABORTING"),
    ABORTED("ABORTED"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackupJobState> VALUE_MAP;
    private final String value;

    private BackupJobState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupJobState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupJobState> knownValues() {
        EnumSet<BackupJobState> knownValues = EnumSet.allOf(BackupJobState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackupJobState.class, BackupJobState::toString);
    }
}

