/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model._stringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportSetting> {
    private static final SdkField<String> REPORT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportTemplate").getter(ReportSetting.getter(ReportSetting::reportTemplate)).setter(ReportSetting.setter(Builder::reportTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTemplate").build()}).build();
    private static final SdkField<List<String>> FRAMEWORK_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FrameworkArns").getter(ReportSetting.getter(ReportSetting::frameworkArns)).setter(ReportSetting.setter(Builder::frameworkArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_FRAMEWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfFrameworks").getter(ReportSetting.getter(ReportSetting::numberOfFrameworks)).setter(ReportSetting.setter(Builder::numberOfFrameworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFrameworks").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_TEMPLATE_FIELD, FRAMEWORK_ARNS_FIELD, NUMBER_OF_FRAMEWORKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reportTemplate;
    private final List<String> frameworkArns;
    private final Integer numberOfFrameworks;

    private ReportSetting(BuilderImpl builder) {
        this.reportTemplate = builder.reportTemplate;
        this.frameworkArns = builder.frameworkArns;
        this.numberOfFrameworks = builder.numberOfFrameworks;
    }

    public final String reportTemplate() {
        return this.reportTemplate;
    }

    public final boolean hasFrameworkArns() {
        return this.frameworkArns != null && !(this.frameworkArns instanceof SdkAutoConstructList);
    }

    public final List<String> frameworkArns() {
        return this.frameworkArns;
    }

    public final Integer numberOfFrameworks() {
        return this.numberOfFrameworks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworkArns() ? this.frameworkArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFrameworks());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportSetting)) {
            return false;
        }
        ReportSetting other = (ReportSetting)obj;
        return Objects.equals(this.reportTemplate(), other.reportTemplate()) && this.hasFrameworkArns() == other.hasFrameworkArns() && Objects.equals(this.frameworkArns(), other.frameworkArns()) && Objects.equals(this.numberOfFrameworks(), other.numberOfFrameworks());
    }

    public final String toString() {
        return ToString.builder((String)"ReportSetting").add("ReportTemplate", (Object)this.reportTemplate()).add("FrameworkArns", this.hasFrameworkArns() ? this.frameworkArns() : null).add("NumberOfFrameworks", (Object)this.numberOfFrameworks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportTemplate": {
                return Optional.ofNullable(clazz.cast(this.reportTemplate()));
            }
            case "FrameworkArns": {
                return Optional.ofNullable(clazz.cast(this.frameworkArns()));
            }
            case "NumberOfFrameworks": {
                return Optional.ofNullable(clazz.cast(this.numberOfFrameworks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportSetting, T> g) {
        return obj -> g.apply((ReportSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportTemplate;
        private List<String> frameworkArns = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfFrameworks;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportSetting model) {
            this.reportTemplate(model.reportTemplate);
            this.frameworkArns(model.frameworkArns);
            this.numberOfFrameworks(model.numberOfFrameworks);
        }

        public final String getReportTemplate() {
            return this.reportTemplate;
        }

        public final void setReportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
        }

        @Override
        public final Builder reportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
            return this;
        }

        public final Collection<String> getFrameworkArns() {
            if (this.frameworkArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.frameworkArns;
        }

        public final void setFrameworkArns(Collection<String> frameworkArns) {
            this.frameworkArns = _stringListCopier.copy(frameworkArns);
        }

        @Override
        public final Builder frameworkArns(Collection<String> frameworkArns) {
            this.frameworkArns = _stringListCopier.copy(frameworkArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkArns(String ... frameworkArns) {
            this.frameworkArns(Arrays.asList(frameworkArns));
            return this;
        }

        public final Integer getNumberOfFrameworks() {
            return this.numberOfFrameworks;
        }

        public final void setNumberOfFrameworks(Integer numberOfFrameworks) {
            this.numberOfFrameworks = numberOfFrameworks;
        }

        @Override
        public final Builder numberOfFrameworks(Integer numberOfFrameworks) {
            this.numberOfFrameworks = numberOfFrameworks;
            return this;
        }

        public ReportSetting build() {
            return new ReportSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportSetting> {
        public Builder reportTemplate(String var1);

        public Builder frameworkArns(Collection<String> var1);

        public Builder frameworkArns(String ... var1);

        public Builder numberOfFrameworks(Integer var1);
    }
}

