/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.BackupVaultListMember;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;

public class ListBackupVaultsPublisher
implements SdkPublisher<ListBackupVaultsResponse> {
    private final BackupAsyncClient client;
    private final ListBackupVaultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupVaultsPublisher(BackupAsyncClient client, ListBackupVaultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupVaultsPublisher(BackupAsyncClient client, ListBackupVaultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupVaultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupVaultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BackupVaultListMember> backupVaultList() {
        Function<ListBackupVaultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupVaultList() != null) {
                return response.backupVaultList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBackupVaultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBackupVaultsResponseFetcher
    implements AsyncPageFetcher<ListBackupVaultsResponse> {
        private ListBackupVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupVaultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupVaultsResponse> nextPage(ListBackupVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupVaultsPublisher.this.client.listBackupVaults(ListBackupVaultsPublisher.this.firstRequest);
            }
            return ListBackupVaultsPublisher.this.client.listBackupVaults((ListBackupVaultsRequest)((Object)ListBackupVaultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

