/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipType;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.MemberArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateChannelMembershipRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, BatchCreateChannelMembershipRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(BatchCreateChannelMembershipRequest.getter(BatchCreateChannelMembershipRequest::channelArn)).setter(BatchCreateChannelMembershipRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(BatchCreateChannelMembershipRequest.getter(BatchCreateChannelMembershipRequest::typeAsString)).setter(BatchCreateChannelMembershipRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> MEMBER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberArns").getter(BatchCreateChannelMembershipRequest.getter(BatchCreateChannelMembershipRequest::memberArns)).setter(BatchCreateChannelMembershipRequest.setter(Builder::memberArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(BatchCreateChannelMembershipRequest.getter(BatchCreateChannelMembershipRequest::chimeBearer)).setter(BatchCreateChannelMembershipRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, TYPE_FIELD, MEMBER_ARNS_FIELD, CHIME_BEARER_FIELD));
    private final String channelArn;
    private final String type;
    private final List<String> memberArns;
    private final String chimeBearer;

    private BatchCreateChannelMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.type = builder.type;
        this.memberArns = builder.memberArns;
        this.chimeBearer = builder.chimeBearer;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasMemberArns() {
        return this.memberArns != null && !(this.memberArns instanceof SdkAutoConstructList);
    }

    public final List<String> memberArns() {
        return this.memberArns;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberArns() ? this.memberArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateChannelMembershipRequest)) {
            return false;
        }
        BatchCreateChannelMembershipRequest other = (BatchCreateChannelMembershipRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasMemberArns() == other.hasMemberArns() && Objects.equals(this.memberArns(), other.memberArns()) && Objects.equals(this.chimeBearer(), other.chimeBearer());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateChannelMembershipRequest").add("ChannelArn", (Object)this.channelArn()).add("Type", (Object)this.typeAsString()).add("MemberArns", this.hasMemberArns() ? this.memberArns() : null).add("ChimeBearer", (Object)this.chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MemberArns": {
                return Optional.ofNullable(clazz.cast(this.memberArns()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateChannelMembershipRequest, T> g) {
        return obj -> g.apply((BatchCreateChannelMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String type;
        private List<String> memberArns = DefaultSdkAutoConstructList.getInstance();
        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateChannelMembershipRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.type(model.type);
            this.memberArns(model.memberArns);
            this.chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getMemberArns() {
            if (this.memberArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberArns;
        }

        public final void setMemberArns(Collection<String> memberArns) {
            this.memberArns = MemberArnsCopier.copy(memberArns);
        }

        @Override
        public final Builder memberArns(Collection<String> memberArns) {
            this.memberArns = MemberArnsCopier.copy(memberArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberArns(String ... memberArns) {
            this.memberArns(Arrays.asList(memberArns));
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateChannelMembershipRequest build() {
            return new BatchCreateChannelMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateChannelMembershipRequest> {
        public Builder channelArn(String var1);

        public Builder type(String var1);

        public Builder type(ChannelMembershipType var1);

        public Builder memberArns(Collection<String> var1);

        public Builder memberArns(String ... var1);

        public Builder chimeBearer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

