/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;

public class ListAttachedIndicesPublisher
implements SdkPublisher<ListAttachedIndicesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListAttachedIndicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedIndicesPublisher(CloudDirectoryAsyncClient client, ListAttachedIndicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedIndicesPublisher(CloudDirectoryAsyncClient client, ListAttachedIndicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedIndicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedIndicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAttachedIndicesResponseFetcher
    implements AsyncPageFetcher<ListAttachedIndicesResponse> {
        private ListAttachedIndicesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedIndicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttachedIndicesResponse> nextPage(ListAttachedIndicesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedIndicesPublisher.this.client.listAttachedIndices(ListAttachedIndicesPublisher.this.firstRequest);
            }
            return ListAttachedIndicesPublisher.this.client.listAttachedIndices((ListAttachedIndicesRequest)((Object)ListAttachedIndicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

