/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStacksResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStacksResponse> {
    private static final SdkField<List<StackSummary>> STACK_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackSummaries").getter(ListStacksResponse.getter(ListStacksResponse::stackSummaries)).setter(ListStacksResponse.setter(Builder::stackSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStacksResponse.getter(ListStacksResponse::nextToken)).setter(ListStacksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<StackSummary> stackSummaries;
    private final String nextToken;

    private ListStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stackSummaries = builder.stackSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStackSummaries() {
        return this.stackSummaries != null && !(this.stackSummaries instanceof SdkAutoConstructList);
    }

    public final List<StackSummary> stackSummaries() {
        return this.stackSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackSummaries() ? this.stackSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksResponse)) {
            return false;
        }
        ListStacksResponse other = (ListStacksResponse)((Object)obj);
        return this.hasStackSummaries() == other.hasStackSummaries() && Objects.equals(this.stackSummaries(), other.stackSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStacksResponse").add("StackSummaries", this.hasStackSummaries() ? this.stackSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSummaries": {
                return Optional.ofNullable(clazz.cast(this.stackSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStacksResponse, T> g) {
        return obj -> g.apply((ListStacksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackSummary> stackSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksResponse model) {
            super(model);
            this.stackSummaries(model.stackSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<StackSummary.Builder> getStackSummaries() {
            List<StackSummary.Builder> result = StackSummariesCopier.copyToBuilder(this.stackSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackSummaries(Collection<StackSummary.BuilderImpl> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copyFromBuilder(stackSummaries);
        }

        @Override
        public final Builder stackSummaries(Collection<StackSummary> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copy(stackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSummaries(StackSummary ... stackSummaries) {
            this.stackSummaries(Arrays.asList(stackSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSummaries(Consumer<StackSummary.Builder> ... stackSummaries) {
            this.stackSummaries(Stream.of(stackSummaries).map(c -> (StackSummary)((StackSummary.Builder)StackSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStacksResponse build() {
            return new ListStacksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStacksResponse> {
        public Builder stackSummaries(Collection<StackSummary> var1);

        public Builder stackSummaries(StackSummary ... var1);

        public Builder stackSummaries(Consumer<StackSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

