/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.PublicKey;

public class ListPublicKeysPublisher
implements SdkPublisher<ListPublicKeysResponse> {
    private final CloudTrailAsyncClient client;
    private final ListPublicKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPublicKeysPublisher(CloudTrailAsyncClient client, ListPublicKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPublicKeysPublisher(CloudTrailAsyncClient client, ListPublicKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPublicKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPublicKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PublicKey> publicKeyList() {
        Function<ListPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.publicKeyList() != null) {
                return response.publicKeyList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPublicKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPublicKeysResponseFetcher
    implements AsyncPageFetcher<ListPublicKeysResponse> {
        private ListPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListPublicKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPublicKeysResponse> nextPage(ListPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListPublicKeysPublisher.this.client.listPublicKeys(ListPublicKeysPublisher.this.firstRequest);
            }
            return ListPublicKeysPublisher.this.client.listPublicKeys((ListPublicKeysRequest)((Object)ListPublicKeysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

