/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> {
    private static final SdkField<List<String>> DISASSOCIATED_REPOSITORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("disassociatedRepositoryNames").getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::disassociatedRepositoryNames)).setter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.setter(Builder::disassociatedRepositoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disassociatedRepositoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::errors)).setter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDisassociateApprovalRuleTemplateFromRepositoriesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISASSOCIATED_REPOSITORY_NAMES_FIELD, ERRORS_FIELD));
    private final List<String> disassociatedRepositoryNames;
    private final List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors;

    private BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.disassociatedRepositoryNames = builder.disassociatedRepositoryNames;
        this.errors = builder.errors;
    }

    public final boolean hasDisassociatedRepositoryNames() {
        return this.disassociatedRepositoryNames != null && !(this.disassociatedRepositoryNames instanceof SdkAutoConstructList);
    }

    public final List<String> disassociatedRepositoryNames() {
        return this.disassociatedRepositoryNames;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisassociatedRepositoryNames() ? this.disassociatedRepositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse)) {
            return false;
        }
        BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse other = (BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse)((Object)obj);
        return this.hasDisassociatedRepositoryNames() == other.hasDisassociatedRepositoryNames() && Objects.equals(this.disassociatedRepositoryNames(), other.disassociatedRepositoryNames()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse").add("DisassociatedRepositoryNames", this.hasDisassociatedRepositoryNames() ? this.disassociatedRepositoryNames() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "disassociatedRepositoryNames": {
                return Optional.ofNullable(clazz.cast(this.disassociatedRepositoryNames()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> disassociatedRepositoryNames = DefaultSdkAutoConstructList.getInstance();
        private List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse model) {
            super(model);
            this.disassociatedRepositoryNames(model.disassociatedRepositoryNames);
            this.errors(model.errors);
        }

        public final Collection<String> getDisassociatedRepositoryNames() {
            if (this.disassociatedRepositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disassociatedRepositoryNames;
        }

        public final void setDisassociatedRepositoryNames(Collection<String> disassociatedRepositoryNames) {
            this.disassociatedRepositoryNames = RepositoryNameListCopier.copy(disassociatedRepositoryNames);
        }

        @Override
        public final Builder disassociatedRepositoryNames(Collection<String> disassociatedRepositoryNames) {
            this.disassociatedRepositoryNames = RepositoryNameListCopier.copy(disassociatedRepositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociatedRepositoryNames(String ... disassociatedRepositoryNames) {
            this.disassociatedRepositoryNames(Arrays.asList(disassociatedRepositoryNames));
            return this;
        }

        public final List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder> getErrors() {
            List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder> result = BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.BuilderImpl> errors) {
            this.errors = BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors) {
            this.errors = BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDisassociateApprovalRuleTemplateFromRepositoriesError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDisassociateApprovalRuleTemplateFromRepositoriesError)((BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder)BatchDisassociateApprovalRuleTemplateFromRepositoriesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse build() {
            return new BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> {
        public Builder disassociatedRepositoryNames(Collection<String> var1);

        public Builder disassociatedRepositoryNames(String ... var1);

        public Builder errors(Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> var1);

        public Builder errors(BatchDisassociateApprovalRuleTemplateFromRepositoriesError ... var1);

        public Builder errors(Consumer<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder> ... var1);
    }
}

