/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum;
import software.amazon.awssdk.services.codecommit.model.SourceFileSpecifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFileEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PutFileEntry> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(PutFileEntry.getter(PutFileEntry::filePath)).setter(PutFileEntry.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> FILE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileMode").getter(PutFileEntry.getter(PutFileEntry::fileModeAsString)).setter(PutFileEntry.setter(Builder::fileMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()}).build();
    private static final SdkField<SdkBytes> FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("fileContent").getter(PutFileEntry.getter(PutFileEntry::fileContent)).setter(PutFileEntry.setter(Builder::fileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContent").build()}).build();
    private static final SdkField<SourceFileSpecifier> SOURCE_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceFile").getter(PutFileEntry.getter(PutFileEntry::sourceFile)).setter(PutFileEntry.setter(Builder::sourceFile)).constructor(SourceFileSpecifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, FILE_MODE_FIELD, FILE_CONTENT_FIELD, SOURCE_FILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String fileMode;
    private final SdkBytes fileContent;
    private final SourceFileSpecifier sourceFile;

    private PutFileEntry(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.fileMode = builder.fileMode;
        this.fileContent = builder.fileContent;
        this.sourceFile = builder.sourceFile;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(this.fileMode);
    }

    public final String fileModeAsString() {
        return this.fileMode;
    }

    public final SdkBytes fileContent() {
        return this.fileContent;
    }

    public final SourceFileSpecifier sourceFile() {
        return this.sourceFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFileEntry)) {
            return false;
        }
        PutFileEntry other = (PutFileEntry)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fileModeAsString(), other.fileModeAsString()) && Objects.equals(this.fileContent(), other.fileContent()) && Objects.equals(this.sourceFile(), other.sourceFile());
    }

    public final String toString() {
        return ToString.builder((String)"PutFileEntry").add("FilePath", (Object)this.filePath()).add("FileMode", (Object)this.fileModeAsString()).add("FileContent", (Object)this.fileContent()).add("SourceFile", (Object)this.sourceFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "fileMode": {
                return Optional.ofNullable(clazz.cast(this.fileModeAsString()));
            }
            case "fileContent": {
                return Optional.ofNullable(clazz.cast(this.fileContent()));
            }
            case "sourceFile": {
                return Optional.ofNullable(clazz.cast(this.sourceFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFileEntry, T> g) {
        return obj -> g.apply((PutFileEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private String fileMode;
        private SdkBytes fileContent;
        private SourceFileSpecifier sourceFile;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFileEntry model) {
            this.filePath(model.filePath);
            this.fileMode(model.fileMode);
            this.fileContent(model.fileContent);
            this.sourceFile(model.sourceFile);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFileMode() {
            return this.fileMode;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final ByteBuffer getFileContent() {
            return this.fileContent == null ? null : this.fileContent.asByteBuffer();
        }

        public final void setFileContent(ByteBuffer fileContent) {
            this.fileContent(fileContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)fileContent));
        }

        @Override
        public final Builder fileContent(SdkBytes fileContent) {
            this.fileContent = fileContent;
            return this;
        }

        public final SourceFileSpecifier.Builder getSourceFile() {
            return this.sourceFile != null ? this.sourceFile.toBuilder() : null;
        }

        public final void setSourceFile(SourceFileSpecifier.BuilderImpl sourceFile) {
            this.sourceFile = sourceFile != null ? sourceFile.build() : null;
        }

        @Override
        public final Builder sourceFile(SourceFileSpecifier sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        public PutFileEntry build() {
            return new PutFileEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PutFileEntry> {
        public Builder filePath(String var1);

        public Builder fileMode(String var1);

        public Builder fileMode(FileModeTypeEnum var1);

        public Builder fileContent(SdkBytes var1);

        public Builder sourceFile(SourceFileSpecifier var1);

        default public Builder sourceFile(Consumer<SourceFileSpecifier.Builder> sourceFile) {
            return this.sourceFile((SourceFileSpecifier)((SourceFileSpecifier.Builder)SourceFileSpecifier.builder().applyMutation(sourceFile)).build());
        }
    }
}

