/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDefaultBranchRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, UpdateDefaultBranchRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(UpdateDefaultBranchRequest.getter(UpdateDefaultBranchRequest::repositoryName)).setter(UpdateDefaultBranchRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> DEFAULT_BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBranchName").getter(UpdateDefaultBranchRequest.getter(UpdateDefaultBranchRequest::defaultBranchName)).setter(UpdateDefaultBranchRequest.setter(Builder::defaultBranchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBranchName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, DEFAULT_BRANCH_NAME_FIELD));
    private final String repositoryName;
    private final String defaultBranchName;

    private UpdateDefaultBranchRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.defaultBranchName = builder.defaultBranchName;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String defaultBranchName() {
        return this.defaultBranchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBranchName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDefaultBranchRequest)) {
            return false;
        }
        UpdateDefaultBranchRequest other = (UpdateDefaultBranchRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.defaultBranchName(), other.defaultBranchName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDefaultBranchRequest").add("RepositoryName", (Object)this.repositoryName()).add("DefaultBranchName", (Object)this.defaultBranchName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "defaultBranchName": {
                return Optional.ofNullable(clazz.cast(this.defaultBranchName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDefaultBranchRequest, T> g) {
        return obj -> g.apply((UpdateDefaultBranchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String defaultBranchName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDefaultBranchRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.defaultBranchName(model.defaultBranchName);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getDefaultBranchName() {
            return this.defaultBranchName;
        }

        public final void setDefaultBranchName(String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
        }

        @Override
        public final Builder defaultBranchName(String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDefaultBranchRequest build() {
            return new UpdateDefaultBranchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDefaultBranchRequest> {
        public Builder repositoryName(String var1);

        public Builder defaultBranchName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

