/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;

public class ListPullRequestsPublisher
implements SdkPublisher<ListPullRequestsResponse> {
    private final CodeCommitAsyncClient client;
    private final ListPullRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPullRequestsPublisher(CodeCommitAsyncClient client, ListPullRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPullRequestsPublisher(CodeCommitAsyncClient client, ListPullRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPullRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPullRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPullRequestsResponseFetcher
    implements AsyncPageFetcher<ListPullRequestsResponse> {
        private ListPullRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListPullRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPullRequestsResponse> nextPage(ListPullRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListPullRequestsPublisher.this.client.listPullRequests(ListPullRequestsPublisher.this.firstRequest);
            }
            return ListPullRequestsPublisher.this.client.listPullRequests((ListPullRequestsRequest)((Object)ListPullRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

