/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostAgentProfileRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, PostAgentProfileRequest> {
    private static final SdkField<SdkBytes> AGENT_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("agentProfile").getter(PostAgentProfileRequest.getter(PostAgentProfileRequest::agentProfile)).setter(PostAgentProfileRequest.setter(Builder::agentProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentProfile").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PostAgentProfileRequest.getter(PostAgentProfileRequest::contentType)).setter(PostAgentProfileRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> PROFILE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileToken").getter(PostAgentProfileRequest.getter(PostAgentProfileRequest::profileToken)).setter(PostAgentProfileRequest.setter(Builder::profileToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("profileToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(PostAgentProfileRequest.getter(PostAgentProfileRequest::profilingGroupName)).setter(PostAgentProfileRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_PROFILE_FIELD, CONTENT_TYPE_FIELD, PROFILE_TOKEN_FIELD, PROFILING_GROUP_NAME_FIELD));
    private final SdkBytes agentProfile;
    private final String contentType;
    private final String profileToken;
    private final String profilingGroupName;

    private PostAgentProfileRequest(BuilderImpl builder) {
        super(builder);
        this.agentProfile = builder.agentProfile;
        this.contentType = builder.contentType;
        this.profileToken = builder.profileToken;
        this.profilingGroupName = builder.profilingGroupName;
    }

    public final SdkBytes agentProfile() {
        return this.agentProfile;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String profileToken() {
        return this.profileToken;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostAgentProfileRequest)) {
            return false;
        }
        PostAgentProfileRequest other = (PostAgentProfileRequest)((Object)obj);
        return Objects.equals(this.agentProfile(), other.agentProfile()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.profileToken(), other.profileToken()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"PostAgentProfileRequest").add("AgentProfile", (Object)this.agentProfile()).add("ContentType", (Object)this.contentType()).add("ProfileToken", (Object)this.profileToken()).add("ProfilingGroupName", (Object)this.profilingGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentProfile": {
                return Optional.ofNullable(clazz.cast(this.agentProfile()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "profileToken": {
                return Optional.ofNullable(clazz.cast(this.profileToken()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostAgentProfileRequest, T> g) {
        return obj -> g.apply((PostAgentProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private SdkBytes agentProfile;
        private String contentType;
        private String profileToken;
        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(PostAgentProfileRequest model) {
            super(model);
            this.agentProfile(model.agentProfile);
            this.contentType(model.contentType);
            this.profileToken(model.profileToken);
            this.profilingGroupName(model.profilingGroupName);
        }

        public final ByteBuffer getAgentProfile() {
            return this.agentProfile == null ? null : this.agentProfile.asByteBuffer();
        }

        public final void setAgentProfile(ByteBuffer agentProfile) {
            this.agentProfile(agentProfile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)agentProfile));
        }

        @Override
        public final Builder agentProfile(SdkBytes agentProfile) {
            this.agentProfile = agentProfile;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getProfileToken() {
            return this.profileToken;
        }

        public final void setProfileToken(String profileToken) {
            this.profileToken = profileToken;
        }

        @Override
        public final Builder profileToken(String profileToken) {
            this.profileToken = profileToken;
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostAgentProfileRequest build() {
            return new PostAgentProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostAgentProfileRequest> {
        public Builder agentProfile(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder profileToken(String var1);

        public Builder profilingGroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

