/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse;

public class ListCodeReviewsIterable
implements SdkIterable<ListCodeReviewsResponse> {
    private final CodeGuruReviewerClient client;
    private final ListCodeReviewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCodeReviewsIterable(CodeGuruReviewerClient client, ListCodeReviewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCodeReviewsResponseFetcher();
    }

    public Iterator<ListCodeReviewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCodeReviewsResponseFetcher
    implements SyncPageFetcher<ListCodeReviewsResponse> {
        private ListCodeReviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeReviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCodeReviewsResponse nextPage(ListCodeReviewsResponse previousPage) {
            if (previousPage == null) {
                return ListCodeReviewsIterable.this.client.listCodeReviews(ListCodeReviewsIterable.this.firstRequest);
            }
            return ListCodeReviewsIterable.this.client.listCodeReviews((ListCodeReviewsRequest)((Object)ListCodeReviewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

