/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DetailType {
    BASIC("BASIC"),
    FULL("FULL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetailType> VALUE_MAP;
    private final String value;

    private DetailType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetailType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetailType> knownValues() {
        EnumSet<DetailType> knownValues = EnumSet.allOf(DetailType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DetailType.class, DetailType::toString);
    }
}

