/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.RetentionConfiguration;

public class DescribeRetentionConfigurationsPublisher
implements SdkPublisher<DescribeRetentionConfigurationsResponse> {
    private final ConfigAsyncClient client;
    private final DescribeRetentionConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRetentionConfigurationsPublisher(ConfigAsyncClient client, DescribeRetentionConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRetentionConfigurationsPublisher(ConfigAsyncClient client, DescribeRetentionConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRetentionConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRetentionConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RetentionConfiguration> retentionConfigurations() {
        Function<DescribeRetentionConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.retentionConfigurations() != null) {
                return response.retentionConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRetentionConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRetentionConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeRetentionConfigurationsResponse> {
        private DescribeRetentionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRetentionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRetentionConfigurationsResponse> nextPage(DescribeRetentionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRetentionConfigurationsPublisher.this.client.describeRetentionConfigurations(DescribeRetentionConfigurationsPublisher.this.firstRequest);
            }
            return DescribeRetentionConfigurationsPublisher.this.client.describeRetentionConfigurations((DescribeRetentionConfigurationsRequest)((Object)DescribeRetentionConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

