/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse;

public class ListContactFlowModulesPublisher
implements SdkPublisher<ListContactFlowModulesResponse> {
    private final ConnectAsyncClient client;
    private final ListContactFlowModulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactFlowModulesPublisher(ConnectAsyncClient client, ListContactFlowModulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactFlowModulesPublisher(ConnectAsyncClient client, ListContactFlowModulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactFlowModulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactFlowModulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlowModuleSummary> contactFlowModulesSummaryList() {
        Function<ListContactFlowModulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModulesSummaryList() != null) {
                return response.contactFlowModulesSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactFlowModulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactFlowModulesResponseFetcher
    implements AsyncPageFetcher<ListContactFlowModulesResponse> {
        private ListContactFlowModulesResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowModulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactFlowModulesResponse> nextPage(ListContactFlowModulesResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowModulesPublisher.this.client.listContactFlowModules(ListContactFlowModulesPublisher.this.firstRequest);
            }
            return ListContactFlowModulesPublisher.this.client.listContactFlowModules((ListContactFlowModulesRequest)((Object)ListContactFlowModulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

