/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChatItemType {
    TYPING("TYPING"),
    PARTICIPANT_JOINED("PARTICIPANT_JOINED"),
    PARTICIPANT_LEFT("PARTICIPANT_LEFT"),
    CHAT_ENDED("CHAT_ENDED"),
    TRANSFER_SUCCEEDED("TRANSFER_SUCCEEDED"),
    TRANSFER_FAILED("TRANSFER_FAILED"),
    MESSAGE("MESSAGE"),
    EVENT("EVENT"),
    ATTACHMENT("ATTACHMENT"),
    CONNECTION_ACK("CONNECTION_ACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChatItemType> VALUE_MAP;
    private final String value;

    private ChatItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChatItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChatItemType> knownValues() {
        EnumSet<ChatItemType> knownValues = EnumSet.allOf(ChatItemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChatItemType.class, ChatItemType::toString);
    }
}

