/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NestingLevelValue {
    NONE("none"),
    ONE("one"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NestingLevelValue> VALUE_MAP;
    private final String value;

    private NestingLevelValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NestingLevelValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NestingLevelValue> knownValues() {
        EnumSet<NestingLevelValue> knownValues = EnumSet.allOf(NestingLevelValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NestingLevelValue.class, NestingLevelValue::toString);
    }
}

