/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricFilterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceInsightsMetricQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceInsightsMetricQuery> {
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(PerformanceInsightsMetricQuery.getter(PerformanceInsightsMetricQuery::metric)).setter(PerformanceInsightsMetricQuery.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<PerformanceInsightsMetricDimensionGroup> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroupBy").getter(PerformanceInsightsMetricQuery.getter(PerformanceInsightsMetricQuery::groupBy)).setter(PerformanceInsightsMetricQuery.setter(Builder::groupBy)).constructor(PerformanceInsightsMetricDimensionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filter").getter(PerformanceInsightsMetricQuery.getter(PerformanceInsightsMetricQuery::filter)).setter(PerformanceInsightsMetricQuery.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, GROUP_BY_FIELD, FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metric;
    private final PerformanceInsightsMetricDimensionGroup groupBy;
    private final Map<String, String> filter;

    private PerformanceInsightsMetricQuery(BuilderImpl builder) {
        this.metric = builder.metric;
        this.groupBy = builder.groupBy;
        this.filter = builder.filter;
    }

    public final String metric() {
        return this.metric;
    }

    public final PerformanceInsightsMetricDimensionGroup groupBy() {
        return this.groupBy;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetricQuery)) {
            return false;
        }
        PerformanceInsightsMetricQuery other = (PerformanceInsightsMetricQuery)obj;
        return Objects.equals(this.metric(), other.metric()) && Objects.equals(this.groupBy(), other.groupBy()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceInsightsMetricQuery").add("Metric", (Object)this.metric()).add("GroupBy", (Object)this.groupBy()).add("Filter", this.hasFilter() ? this.filter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsMetricQuery, T> g) {
        return obj -> g.apply((PerformanceInsightsMetricQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metric;
        private PerformanceInsightsMetricDimensionGroup groupBy;
        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsMetricQuery model) {
            this.metric(model.metric);
            this.groupBy(model.groupBy);
            this.filter(model.filter);
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final PerformanceInsightsMetricDimensionGroup.Builder getGroupBy() {
            return this.groupBy != null ? this.groupBy.toBuilder() : null;
        }

        public final void setGroupBy(PerformanceInsightsMetricDimensionGroup.BuilderImpl groupBy) {
            this.groupBy = groupBy != null ? groupBy.build() : null;
        }

        @Override
        public final Builder groupBy(PerformanceInsightsMetricDimensionGroup groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final Map<String, String> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = PerformanceInsightsMetricFilterMapCopier.copy(filter);
        }

        @Override
        public final Builder filter(Map<String, String> filter) {
            this.filter = PerformanceInsightsMetricFilterMapCopier.copy(filter);
            return this;
        }

        public PerformanceInsightsMetricQuery build() {
            return new PerformanceInsightsMetricQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceInsightsMetricQuery> {
        public Builder metric(String var1);

        public Builder groupBy(PerformanceInsightsMetricDimensionGroup var1);

        default public Builder groupBy(Consumer<PerformanceInsightsMetricDimensionGroup.Builder> groupBy) {
            return this.groupBy((PerformanceInsightsMetricDimensionGroup)((PerformanceInsightsMetricDimensionGroup.Builder)PerformanceInsightsMetricDimensionGroup.builder().applyMutation(groupBy)).build());
        }

        public Builder filter(Map<String, String> var1);
    }
}

