/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost;

public class GetCostEstimationPublisher
implements SdkPublisher<GetCostEstimationResponse> {
    private final DevOpsGuruAsyncClient client;
    private final GetCostEstimationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCostEstimationPublisher(DevOpsGuruAsyncClient client, GetCostEstimationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCostEstimationPublisher(DevOpsGuruAsyncClient client, GetCostEstimationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCostEstimationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCostEstimationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceResourceCost> costs() {
        Function<GetCostEstimationResponse, Iterator> getIterator = response -> {
            if (response != null && response.costs() != null) {
                return response.costs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCostEstimationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCostEstimationResponseFetcher
    implements AsyncPageFetcher<GetCostEstimationResponse> {
        private GetCostEstimationResponseFetcher() {
        }

        public boolean hasNextPage(GetCostEstimationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCostEstimationResponse> nextPage(GetCostEstimationResponse previousPage) {
            if (previousPage == null) {
                return GetCostEstimationPublisher.this.client.getCostEstimation(GetCostEstimationPublisher.this.firstRequest);
            }
            return GetCostEstimationPublisher.this.client.getCostEstimation((GetCostEstimationRequest)((Object)GetCostEstimationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

