/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsResponse;
import software.amazon.awssdk.services.drs.model.RecoverySnapshot;

public class DescribeRecoverySnapshotsPublisher
implements SdkPublisher<DescribeRecoverySnapshotsResponse> {
    private final DrsAsyncClient client;
    private final DescribeRecoverySnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRecoverySnapshotsPublisher(DrsAsyncClient client, DescribeRecoverySnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRecoverySnapshotsPublisher(DrsAsyncClient client, DescribeRecoverySnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRecoverySnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRecoverySnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecoverySnapshot> items() {
        Function<DescribeRecoverySnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRecoverySnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRecoverySnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeRecoverySnapshotsResponse> {
        private DescribeRecoverySnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecoverySnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRecoverySnapshotsResponse> nextPage(DescribeRecoverySnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecoverySnapshotsPublisher.this.client.describeRecoverySnapshots(DescribeRecoverySnapshotsPublisher.this.firstRequest);
            }
            return DescribeRecoverySnapshotsPublisher.this.client.describeRecoverySnapshots((DescribeRecoverySnapshotsRequest)((Object)DescribeRecoverySnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

