/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationOptionValueType {
    SCALAR("Scalar"),
    LIST("List"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationOptionValueType> VALUE_MAP;
    private final String value;

    private ConfigurationOptionValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationOptionValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationOptionValueType> knownValues() {
        EnumSet<ConfigurationOptionValueType> knownValues = EnumSet.allOf(ConfigurationOptionValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationOptionValueType.class, ConfigurationOptionValueType::toString);
    }
}

