/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.EksInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerInfo> {
    private static final SdkField<EksInfo> EKS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksInfo").getter(ContainerInfo.getter(ContainerInfo::eksInfo)).setter(ContainerInfo.setter(Builder::eksInfo)).constructor(EksInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final EksInfo eksInfo;
    private final Type type;

    private ContainerInfo(BuilderImpl builder) {
        this.eksInfo = builder.eksInfo;
        this.type = builder.type;
    }

    public final EksInfo eksInfo() {
        return this.eksInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInfo)) {
            return false;
        }
        ContainerInfo other = (ContainerInfo)obj;
        return Objects.equals(this.eksInfo(), other.eksInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerInfo").add("EksInfo", (Object)this.eksInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksInfo": {
                return Optional.ofNullable(clazz.cast(this.eksInfo()));
            }
        }
        return Optional.empty();
    }

    public static ContainerInfo fromEksInfo(EksInfo eksInfo) {
        return (ContainerInfo)ContainerInfo.builder().eksInfo(eksInfo).build();
    }

    public static ContainerInfo fromEksInfo(Consumer<EksInfo.Builder> eksInfo) {
        EksInfo.Builder builder = EksInfo.builder();
        eksInfo.accept(builder);
        return ContainerInfo.fromEksInfo((EksInfo)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerInfo, T> g) {
        return obj -> g.apply((ContainerInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EKS_INFO,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EksInfo eksInfo;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInfo model) {
            this.eksInfo(model.eksInfo);
        }

        public final EksInfo.Builder getEksInfo() {
            return this.eksInfo != null ? this.eksInfo.toBuilder() : null;
        }

        public final void setEksInfo(EksInfo.BuilderImpl eksInfo) {
            EksInfo oldValue = this.eksInfo;
            this.eksInfo = eksInfo != null ? eksInfo.build() : null;
            this.handleUnionValueChange(Type.EKS_INFO, oldValue, this.eksInfo);
        }

        @Override
        public final Builder eksInfo(EksInfo eksInfo) {
            EksInfo oldValue = this.eksInfo;
            this.eksInfo = eksInfo;
            this.handleUnionValueChange(Type.EKS_INFO, oldValue, this.eksInfo);
            return this;
        }

        public ContainerInfo build() {
            return new ContainerInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerInfo> {
        public Builder eksInfo(EksInfo var1);

        default public Builder eksInfo(Consumer<EksInfo.Builder> eksInfo) {
            return this.eksInfo((EksInfo)((EksInfo.Builder)EksInfo.builder().applyMutation(eksInfo)).build());
        }
    }
}

