/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.internal;

import java.util.ArrayList;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.SignerLoader;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.util.SignerOverrideUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionScope;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequest;
import software.amazon.awssdk.utils.HostnameValidator;

@SdkInternalApi
public final class MultiRegionEndpointInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<String> MULTI_REGION_ENDPOINT = new ExecutionAttribute("MultiRegionEndpoint");
    private static final Pattern HOSTNAME_COMPLIANT_PATTERN = Pattern.compile("[A-Za-z0-9\\-.]+");

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        String endpointId = MultiRegionEndpointInterceptor.getEndpointId(context.request());
        if (endpointId != null) {
            return MultiRegionEndpointInterceptor.handleMultiRegionEndpoint(endpointId, context.request(), executionAttributes);
        }
        return context.request();
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        String endpoint = (String)executionAttributes.getAttribute(MULTI_REGION_ENDPOINT);
        if (endpoint != null) {
            return (SdkHttpRequest)context.httpRequest().copy(r -> r.host(endpoint));
        }
        return context.httpRequest();
    }

    private static String getEndpointId(SdkRequest request) {
        if (request instanceof PutEventsRequest) {
            return ((PutEventsRequest)request).endpointId();
        }
        return null;
    }

    private static SdkRequest handleMultiRegionEndpoint(String endpointId, SdkRequest request, ExecutionAttributes executionAttributes) {
        MultiRegionEndpointInterceptor.validateEndpointId(endpointId);
        MultiRegionEndpointInterceptor.validateClientConfiguration(executionAttributes);
        if (!MultiRegionEndpointInterceptor.isEndpointOverridden(executionAttributes)) {
            String endpoint = MultiRegionEndpointInterceptor.constructEndpoint(endpointId, executionAttributes);
            executionAttributes.putAttribute(MULTI_REGION_ENDPOINT, (Object)endpoint);
        }
        return MultiRegionEndpointInterceptor.enableSigV4a(request, executionAttributes);
    }

    private static void validateEndpointId(String endpointId) {
        HostnameValidator.validateHostnameCompliant((String)endpointId, (String)"endpointId", (String)"PutEventsRequest", (Pattern)HOSTNAME_COMPLIANT_PATTERN);
    }

    private static void validateClientConfiguration(ExecutionAttributes executionAttributes) {
        if (MultiRegionEndpointInterceptor.isFipsEnabled(executionAttributes)) {
            throw new IllegalStateException("FIPS is not supported with EventBridge multi-region endpoints");
        }
    }

    private static String constructEndpoint(String endpointId, ExecutionAttributes executionAttributes) {
        Region clientRegion = (Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION);
        PartitionEndpointKey partitionEndpointKey = MultiRegionEndpointInterceptor.getPartitionEndpointKey(executionAttributes);
        String dnsSuffix = clientRegion.metadata().partition().dnsSuffix(partitionEndpointKey);
        return String.format("%s.endpoint.events.%s", endpointId, dnsSuffix);
    }

    private static PartitionEndpointKey getPartitionEndpointKey(ExecutionAttributes executionAttributes) {
        ArrayList<EndpointTag> tags = new ArrayList<EndpointTag>();
        if (MultiRegionEndpointInterceptor.isFipsEnabled(executionAttributes)) {
            tags.add(EndpointTag.FIPS);
        }
        if (MultiRegionEndpointInterceptor.isDualstackEnabled(executionAttributes)) {
            tags.add(EndpointTag.DUALSTACK);
        }
        return PartitionEndpointKey.builder().tags(tags).build();
    }

    private static SdkRequest enableSigV4a(SdkRequest request, ExecutionAttributes executionAttributes) {
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE, (Object)RegionScope.GLOBAL);
        return SignerOverrideUtils.overrideSignerIfNotOverridden((SdkRequest)request, (ExecutionAttributes)executionAttributes, SignerLoader::getSigV4aSigner);
    }

    private static boolean isEndpointOverridden(ExecutionAttributes executionAttributes) {
        return Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN));
    }

    private static boolean isDualstackEnabled(ExecutionAttributes executionAttributes) {
        return Boolean.TRUE.equals(executionAttributes.getAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED));
    }

    private static boolean isFipsEnabled(ExecutionAttributes executionAttributes) {
        return Boolean.TRUE.equals(executionAttributes.getAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED));
    }
}

