/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClient;
import software.amazon.awssdk.services.finspacedata.model.DataViewSummary;
import software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse;

public class ListDataViewsIterable
implements SdkIterable<ListDataViewsResponse> {
    private final FinspaceDataClient client;
    private final ListDataViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataViewsIterable(FinspaceDataClient client, ListDataViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataViewsResponseFetcher();
    }

    public Iterator<ListDataViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataViewSummary> dataViews() {
        Function<ListDataViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataViews() != null) {
                return response.dataViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataViewsResponseFetcher
    implements SyncPageFetcher<ListDataViewsResponse> {
        private ListDataViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataViewsResponse nextPage(ListDataViewsResponse previousPage) {
            if (previousPage == null) {
                return ListDataViewsIterable.this.client.listDataViews(ListDataViewsIterable.this.firstRequest);
            }
            return ListDataViewsIterable.this.client.listDataViews((ListDataViewsRequest)((Object)ListDataViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

