/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates;
import software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemWindowsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFileSystemWindowsConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(UpdateFileSystemWindowsConfiguration.getter(UpdateFileSystemWindowsConfiguration::weeklyMaintenanceStartTime)).setter(UpdateFileSystemWindowsConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(UpdateFileSystemWindowsConfiguration.getter(UpdateFileSystemWindowsConfiguration::dailyAutomaticBackupStartTime)).setter(UpdateFileSystemWindowsConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(UpdateFileSystemWindowsConfiguration.getter(UpdateFileSystemWindowsConfiguration::automaticBackupRetentionDays)).setter(UpdateFileSystemWindowsConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(UpdateFileSystemWindowsConfiguration.getter(UpdateFileSystemWindowsConfiguration::throughputCapacity)).setter(UpdateFileSystemWindowsConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<SelfManagedActiveDirectoryConfigurationUpdates> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedActiveDirectoryConfiguration").getter(UpdateFileSystemWindowsConfiguration.getter(UpdateFileSystemWindowsConfiguration::selfManagedActiveDirectoryConfiguration)).setter(UpdateFileSystemWindowsConfiguration.setter(Builder::selfManagedActiveDirectoryConfiguration)).constructor(SelfManagedActiveDirectoryConfigurationUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<WindowsAuditLogCreateConfiguration> AUDIT_LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuditLogConfiguration").getter(UpdateFileSystemWindowsConfiguration.getter(UpdateFileSystemWindowsConfiguration::auditLogConfiguration)).setter(UpdateFileSystemWindowsConfiguration.setter(Builder::auditLogConfiguration)).constructor(WindowsAuditLogCreateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, THROUGHPUT_CAPACITY_FIELD, SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, AUDIT_LOG_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String weeklyMaintenanceStartTime;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final Integer throughputCapacity;
    private final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;
    private final WindowsAuditLogCreateConfiguration auditLogConfiguration;

    private UpdateFileSystemWindowsConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.throughputCapacity = builder.throughputCapacity;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.auditLogConfiguration = builder.auditLogConfiguration;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration() {
        return this.selfManagedActiveDirectoryConfiguration;
    }

    public final WindowsAuditLogCreateConfiguration auditLogConfiguration() {
        return this.auditLogConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemWindowsConfiguration)) {
            return false;
        }
        UpdateFileSystemWindowsConfiguration other = (UpdateFileSystemWindowsConfiguration)obj;
        return Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration()) && Objects.equals(this.auditLogConfiguration(), other.auditLogConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemWindowsConfiguration").add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("SelfManagedActiveDirectoryConfiguration", (Object)this.selfManagedActiveDirectoryConfiguration()).add("AuditLogConfiguration", (Object)this.auditLogConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "SelfManagedActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selfManagedActiveDirectoryConfiguration()));
            }
            case "AuditLogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.auditLogConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemWindowsConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemWindowsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String weeklyMaintenanceStartTime;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private Integer throughputCapacity;
        private SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;
        private WindowsAuditLogCreateConfiguration auditLogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemWindowsConfiguration model) {
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.throughputCapacity(model.throughputCapacity);
            this.selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            this.auditLogConfiguration(model.auditLogConfiguration);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final SelfManagedActiveDirectoryConfigurationUpdates.Builder getSelfManagedActiveDirectoryConfiguration() {
            return this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.build() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final WindowsAuditLogCreateConfiguration.Builder getAuditLogConfiguration() {
            return this.auditLogConfiguration != null ? this.auditLogConfiguration.toBuilder() : null;
        }

        public final void setAuditLogConfiguration(WindowsAuditLogCreateConfiguration.BuilderImpl auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration != null ? auditLogConfiguration.build() : null;
        }

        @Override
        public final Builder auditLogConfiguration(WindowsAuditLogCreateConfiguration auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration;
            return this;
        }

        public UpdateFileSystemWindowsConfiguration build() {
            return new UpdateFileSystemWindowsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemWindowsConfiguration> {
        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder throughputCapacity(Integer var1);

        public Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates var1);

        default public Builder selfManagedActiveDirectoryConfiguration(Consumer<SelfManagedActiveDirectoryConfigurationUpdates.Builder> selfManagedActiveDirectoryConfiguration) {
            return this.selfManagedActiveDirectoryConfiguration((SelfManagedActiveDirectoryConfigurationUpdates)((SelfManagedActiveDirectoryConfigurationUpdates.Builder)SelfManagedActiveDirectoryConfigurationUpdates.builder().applyMutation(selfManagedActiveDirectoryConfiguration)).build());
        }

        public Builder auditLogConfiguration(WindowsAuditLogCreateConfiguration var1);

        default public Builder auditLogConfiguration(Consumer<WindowsAuditLogCreateConfiguration.Builder> auditLogConfiguration) {
            return this.auditLogConfiguration((WindowsAuditLogCreateConfiguration)((WindowsAuditLogCreateConfiguration.Builder)WindowsAuditLogCreateConfiguration.builder().applyMutation(auditLogConfiguration)).build());
        }
    }
}

