/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetail;

public class DescribeGameSessionDetailsPublisher
implements SdkPublisher<DescribeGameSessionDetailsResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeGameSessionDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGameSessionDetailsPublisher(GameLiftAsyncClient client, DescribeGameSessionDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGameSessionDetailsPublisher(GameLiftAsyncClient client, DescribeGameSessionDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGameSessionDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGameSessionDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameSessionDetail> gameSessionDetails() {
        Function<DescribeGameSessionDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessionDetails() != null) {
                return response.gameSessionDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGameSessionDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGameSessionDetailsResponseFetcher
    implements AsyncPageFetcher<DescribeGameSessionDetailsResponse> {
        private DescribeGameSessionDetailsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameSessionDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeGameSessionDetailsResponse> nextPage(DescribeGameSessionDetailsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameSessionDetailsPublisher.this.client.describeGameSessionDetails(DescribeGameSessionDetailsPublisher.this.firstRequest);
            }
            return DescribeGameSessionDetailsPublisher.this.client.describeGameSessionDetails((DescribeGameSessionDetailsRequest)((Object)DescribeGameSessionDetailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

