/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.Instance;

public class DescribeInstancesIterable
implements SdkIterable<DescribeInstancesResponse> {
    private final GameLiftClient client;
    private final DescribeInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancesIterable(GameLiftClient client, DescribeInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstancesResponseFetcher();
    }

    public Iterator<DescribeInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Instance> instances() {
        Function<DescribeInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstancesResponseFetcher
    implements SyncPageFetcher<DescribeInstancesResponse> {
        private DescribeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstancesResponse nextPage(DescribeInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancesIterable.this.client.describeInstances(DescribeInstancesIterable.this.firstRequest);
            }
            return DescribeInstancesIterable.this.client.describeInstances((DescribeInstancesRequest)((Object)DescribeInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

