/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.model.AccessDeniedException;
import software.amazon.awssdk.services.gamesparks.model.ConflictException;
import software.amazon.awssdk.services.gamesparks.model.CreateGameRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateGameResponse;
import software.amazon.awssdk.services.gamesparks.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.CreateStageRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateStageResponse;
import software.amazon.awssdk.services.gamesparks.model.DeleteGameRequest;
import software.amazon.awssdk.services.gamesparks.model.DeleteGameResponse;
import software.amazon.awssdk.services.gamesparks.model.DeleteStageRequest;
import software.amazon.awssdk.services.gamesparks.model.DeleteStageResponse;
import software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerRequest;
import software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerResponse;
import software.amazon.awssdk.services.gamesparks.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.GameSparksException;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionResponse;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGameRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGameResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobResponse;
import software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusRequest;
import software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusResponse;
import software.amazon.awssdk.services.gamesparks.model.GetSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.GetSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentRequest;
import software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentResponse;
import software.amazon.awssdk.services.gamesparks.model.GetStageRequest;
import software.amazon.awssdk.services.gamesparks.model.GetStageResponse;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.InternalServerException;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListGamesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGamesResponse;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListStagesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStagesResponse;
import software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.gamesparks.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobRequest;
import software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobResponse;
import software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentRequest;
import software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentResponse;
import software.amazon.awssdk.services.gamesparks.model.TagResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.TagResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.ThrottlingException;
import software.amazon.awssdk.services.gamesparks.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateStageRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateStageResponse;
import software.amazon.awssdk.services.gamesparks.model.ValidationException;
import software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable;
import software.amazon.awssdk.services.gamesparks.transform.CreateGameRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.DeleteGameRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.DisconnectPlayerRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ExportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetExtensionRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetExtensionVersionRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetGameConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetGameRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetGeneratedCodeJobRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetPlayerConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetSnapshotRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetStageDeploymentRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ImportGameConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListExtensionVersionsRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListExtensionsRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListGamesRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListGeneratedCodeJobsRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListStageDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListStagesRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.StartGeneratedCodeJobRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.StartStageDeploymentRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.UpdateGameConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.UpdateGameRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.gamesparks.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultGameSparksClient
implements GameSparksClient {
    private static final Logger log = Logger.loggerFor(DefaultGameSparksClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGameSparksClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "gamesparks";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGameResponse createGame(CreateGameRequest createGameRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, createGameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGame");
            CreateGameResponse createGameResponse = (CreateGameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGame").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$createGame$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$createSnapshot$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStageResponse createStage(CreateStageRequest createStageRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, createStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStage");
            CreateStageResponse createStageResponse = (CreateStageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$createStage$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGameResponse deleteGame(DeleteGameRequest deleteGameRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, deleteGameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGame");
            DeleteGameResponse deleteGameResponse = (DeleteGameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGame").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$deleteGame$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, deleteStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStage");
            DeleteStageResponse deleteStageResponse = (DeleteStageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$deleteStage$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisconnectPlayerResponse disconnectPlayer(DisconnectPlayerRequest disconnectPlayerRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectPlayerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, disconnectPlayerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectPlayer");
            DisconnectPlayerResponse disconnectPlayerResponse = (DisconnectPlayerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectPlayer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disconnectPlayerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisconnectPlayerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disconnectPlayerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$disconnectPlayer$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportSnapshotResponse exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, exportSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportSnapshot");
            ExportSnapshotResponse exportSnapshotResponse = (ExportSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$exportSnapshot$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExtensionResponse getExtension(GetExtensionRequest getExtensionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExtensionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getExtensionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExtension");
            GetExtensionResponse getExtensionResponse = (GetExtensionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExtension").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getExtensionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExtensionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getExtension$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExtensionVersionResponse getExtensionVersion(GetExtensionVersionRequest getExtensionVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExtensionVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getExtensionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExtensionVersion");
            GetExtensionVersionResponse getExtensionVersionResponse = (GetExtensionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExtensionVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getExtensionVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExtensionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExtensionVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getExtensionVersion$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGameResponse getGame(GetGameRequest getGameRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getGameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGame");
            GetGameResponse getGameResponse = (GetGameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGame").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getGame$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGameConfigurationResponse getGameConfiguration(GetGameConfigurationRequest getGameConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGameConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getGameConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGameConfiguration");
            GetGameConfigurationResponse getGameConfigurationResponse = (GetGameConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGameConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGameConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGameConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGameConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getGameConfiguration$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGeneratedCodeJobResponse getGeneratedCodeJob(GetGeneratedCodeJobRequest getGeneratedCodeJobRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGeneratedCodeJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getGeneratedCodeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGeneratedCodeJob");
            GetGeneratedCodeJobResponse getGeneratedCodeJobResponse = (GetGeneratedCodeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeneratedCodeJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGeneratedCodeJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGeneratedCodeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGeneratedCodeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getGeneratedCodeJob$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPlayerConnectionStatusResponse getPlayerConnectionStatus(GetPlayerConnectionStatusRequest getPlayerConnectionStatusRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPlayerConnectionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getPlayerConnectionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPlayerConnectionStatus");
            GetPlayerConnectionStatusResponse getPlayerConnectionStatusResponse = (GetPlayerConnectionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPlayerConnectionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPlayerConnectionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPlayerConnectionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPlayerConnectionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getPlayerConnectionStatus$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotResponse getSnapshot(GetSnapshotRequest getSnapshotRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshot");
            GetSnapshotResponse getSnapshotResponse = (GetSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getSnapshot$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStageResponse getStage(GetStageRequest getStageRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStage");
            GetStageResponse getStageResponse = (GetStageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getStageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getStageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getStage$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStageDeploymentResponse getStageDeployment(GetStageDeploymentRequest getStageDeploymentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStageDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, getStageDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStageDeployment");
            GetStageDeploymentResponse getStageDeploymentResponse = (GetStageDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStageDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getStageDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetStageDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getStageDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$getStageDeployment$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportGameConfigurationResponse importGameConfiguration(ImportGameConfigurationRequest importGameConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportGameConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, importGameConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportGameConfiguration");
            ImportGameConfigurationResponse importGameConfigurationResponse = (ImportGameConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportGameConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importGameConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportGameConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importGameConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$importGameConfiguration$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExtensionVersionsResponse listExtensionVersions(ListExtensionVersionsRequest listExtensionVersionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExtensionVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listExtensionVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExtensionVersions");
            ListExtensionVersionsResponse listExtensionVersionsResponse = (ListExtensionVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExtensionVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExtensionVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExtensionVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExtensionVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listExtensionVersions$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExtensionVersionsIterable listExtensionVersionsPaginator(ListExtensionVersionsRequest listExtensionVersionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListExtensionVersionsIterable(this, this.applyPaginatorUserAgent(listExtensionVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExtensionsResponse listExtensions(ListExtensionsRequest listExtensionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExtensionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listExtensionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExtensions");
            ListExtensionsResponse listExtensionsResponse = (ListExtensionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExtensions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExtensionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExtensionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExtensionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listExtensions$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExtensionsIterable listExtensionsPaginator(ListExtensionsRequest listExtensionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListExtensionsIterable(this, this.applyPaginatorUserAgent(listExtensionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGamesResponse listGames(ListGamesRequest listGamesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGamesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listGamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGames");
            ListGamesResponse listGamesResponse = (ListGamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGames").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listGames$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGamesIterable listGamesPaginator(ListGamesRequest listGamesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListGamesIterable(this, this.applyPaginatorUserAgent(listGamesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGeneratedCodeJobsResponse listGeneratedCodeJobs(ListGeneratedCodeJobsRequest listGeneratedCodeJobsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGeneratedCodeJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listGeneratedCodeJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGeneratedCodeJobs");
            ListGeneratedCodeJobsResponse listGeneratedCodeJobsResponse = (ListGeneratedCodeJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeneratedCodeJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGeneratedCodeJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGeneratedCodeJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGeneratedCodeJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listGeneratedCodeJobs$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGeneratedCodeJobsIterable listGeneratedCodeJobsPaginator(ListGeneratedCodeJobsRequest listGeneratedCodeJobsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListGeneratedCodeJobsIterable(this, this.applyPaginatorUserAgent(listGeneratedCodeJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest listSnapshotsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSnapshots");
            ListSnapshotsResponse listSnapshotsResponse = (ListSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listSnapshots$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSnapshotsIterable listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListSnapshotsIterable(this, this.applyPaginatorUserAgent(listSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStageDeploymentsResponse listStageDeployments(ListStageDeploymentsRequest listStageDeploymentsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStageDeploymentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listStageDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStageDeployments");
            ListStageDeploymentsResponse listStageDeploymentsResponse = (ListStageDeploymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStageDeployments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStageDeploymentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStageDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStageDeploymentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listStageDeployments$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListStageDeploymentsIterable listStageDeploymentsPaginator(ListStageDeploymentsRequest listStageDeploymentsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListStageDeploymentsIterable(this, this.applyPaginatorUserAgent(listStageDeploymentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStagesResponse listStages(ListStagesRequest listStagesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listStagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStages");
            ListStagesResponse listStagesResponse = (ListStagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listStages$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListStagesIterable listStagesPaginator(ListStagesRequest listStagesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListStagesIterable(this, this.applyPaginatorUserAgent(listStagesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$listTagsForResource$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartGeneratedCodeJobResponse startGeneratedCodeJob(StartGeneratedCodeJobRequest startGeneratedCodeJobRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartGeneratedCodeJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, startGeneratedCodeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartGeneratedCodeJob");
            StartGeneratedCodeJobResponse startGeneratedCodeJobResponse = (StartGeneratedCodeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartGeneratedCodeJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startGeneratedCodeJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartGeneratedCodeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startGeneratedCodeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$startGeneratedCodeJob$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartStageDeploymentResponse startStageDeployment(StartStageDeploymentRequest startStageDeploymentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStageDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, startStageDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartStageDeployment");
            StartStageDeploymentResponse startStageDeploymentResponse = (StartStageDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStageDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startStageDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartStageDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startStageDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$startStageDeployment$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameResponse updateGame(UpdateGameRequest updateGameRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, updateGameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGame");
            UpdateGameResponse updateGameResponse = (UpdateGameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGame").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$updateGame$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameConfigurationResponse updateGameConfiguration(UpdateGameConfigurationRequest updateGameConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, updateGameConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGameConfiguration");
            UpdateGameConfigurationResponse updateGameConfigurationResponse = (UpdateGameConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGameConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGameConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGameConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$updateGameConfiguration$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, updateSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSnapshot");
            UpdateSnapshotResponse updateSnapshotResponse = (UpdateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$updateSnapshot$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGameSparksClient.resolveMetricPublishers(this.clientConfiguration, updateStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GameSparks");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStage");
            UpdateStageResponse updateStageResponse = (UpdateStageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGameSparksClient.lambda$updateStage$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GameSparksException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends GameSparksRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.194").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GameSparksRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateStage$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSnapshot$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGameConfiguration$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGame$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startStageDeployment$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startGeneratedCodeJob$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStages$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStageDeployments$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSnapshots$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGeneratedCodeJobs$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGames$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExtensions$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExtensionVersions$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importGameConfiguration$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStageDeployment$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStage$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSnapshot$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPlayerConnectionStatus$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGeneratedCodeJob$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGameConfiguration$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGame$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExtensionVersion$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExtension$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportSnapshot$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectPlayer$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStage$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGame$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStage$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGame$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

