/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.model.ExtensionDetails;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse;

public class ListExtensionsPublisher
implements SdkPublisher<ListExtensionsResponse> {
    private final GameSparksAsyncClient client;
    private final ListExtensionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExtensionsPublisher(GameSparksAsyncClient client, ListExtensionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExtensionsPublisher(GameSparksAsyncClient client, ListExtensionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExtensionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExtensionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExtensionDetails> extensions() {
        Function<ListExtensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.extensions() != null) {
                return response.extensions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExtensionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExtensionsResponseFetcher
    implements AsyncPageFetcher<ListExtensionsResponse> {
        private ListExtensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExtensionsResponse> nextPage(ListExtensionsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionsPublisher.this.client.listExtensions(ListExtensionsPublisher.this.firstRequest);
            }
            return ListExtensionsPublisher.this.client.listExtensions((ListExtensionsRequest)((Object)ListExtensionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

