/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse;

public class ListGeneratedCodeJobsIterable
implements SdkIterable<ListGeneratedCodeJobsResponse> {
    private final GameSparksClient client;
    private final ListGeneratedCodeJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGeneratedCodeJobsIterable(GameSparksClient client, ListGeneratedCodeJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGeneratedCodeJobsResponseFetcher();
    }

    public Iterator<ListGeneratedCodeJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GeneratedCodeJobDetails> generatedCodeJobs() {
        Function<ListGeneratedCodeJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.generatedCodeJobs() != null) {
                return response.generatedCodeJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGeneratedCodeJobsResponseFetcher
    implements SyncPageFetcher<ListGeneratedCodeJobsResponse> {
        private ListGeneratedCodeJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListGeneratedCodeJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGeneratedCodeJobsResponse nextPage(ListGeneratedCodeJobsResponse previousPage) {
            if (previousPage == null) {
                return ListGeneratedCodeJobsIterable.this.client.listGeneratedCodeJobs(ListGeneratedCodeJobsIterable.this.firstRequest);
            }
            return ListGeneratedCodeJobsIterable.this.client.listGeneratedCodeJobs((ListGeneratedCodeJobsRequest)((Object)ListGeneratedCodeJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

