/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.model.ListStagesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStagesResponse;
import software.amazon.awssdk.services.gamesparks.model.StageSummary;

public class ListStagesPublisher
implements SdkPublisher<ListStagesResponse> {
    private final GameSparksAsyncClient client;
    private final ListStagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStagesPublisher(GameSparksAsyncClient client, ListStagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStagesPublisher(GameSparksAsyncClient client, ListStagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StageSummary> stages() {
        Function<ListStagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stages() != null) {
                return response.stages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStagesResponseFetcher
    implements AsyncPageFetcher<ListStagesResponse> {
        private ListStagesResponseFetcher() {
        }

        public boolean hasNextPage(ListStagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStagesResponse> nextPage(ListStagesResponse previousPage) {
            if (previousPage == null) {
                return ListStagesPublisher.this.client.listStages(ListStagesPublisher.this.firstRequest);
            }
            return ListStagesPublisher.this.client.listStages((ListStagesRequest)((Object)ListStagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

