/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;

public class ListByoipCidrsPublisher
implements SdkPublisher<ListByoipCidrsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListByoipCidrsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListByoipCidrsPublisher(GlobalAcceleratorAsyncClient client, ListByoipCidrsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListByoipCidrsPublisher(GlobalAcceleratorAsyncClient client, ListByoipCidrsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListByoipCidrsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListByoipCidrsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ByoipCidr> byoipCidrs() {
        Function<ListByoipCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.byoipCidrs() != null) {
                return response.byoipCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListByoipCidrsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListByoipCidrsResponseFetcher
    implements AsyncPageFetcher<ListByoipCidrsResponse> {
        private ListByoipCidrsResponseFetcher() {
        }

        public boolean hasNextPage(ListByoipCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListByoipCidrsResponse> nextPage(ListByoipCidrsResponse previousPage) {
            if (previousPage == null) {
                return ListByoipCidrsPublisher.this.client.listByoipCidrs(ListByoipCidrsPublisher.this.firstRequest);
            }
            return ListByoipCidrsPublisher.this.client.listByoipCidrs((ListByoipCidrsRequest)((Object)ListByoipCidrsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

