/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.AssociatedClientDevice;
import software.amazon.awssdk.services.greengrassv2.model.AssociatedClientDeviceListCopier;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClientDevicesAssociatedWithCoreDeviceResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, ListClientDevicesAssociatedWithCoreDeviceResponse> {
    private static final SdkField<List<AssociatedClientDevice>> ASSOCIATED_CLIENT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedClientDevices").getter(ListClientDevicesAssociatedWithCoreDeviceResponse.getter(ListClientDevicesAssociatedWithCoreDeviceResponse::associatedClientDevices)).setter(ListClientDevicesAssociatedWithCoreDeviceResponse.setter(Builder::associatedClientDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedClientDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedClientDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListClientDevicesAssociatedWithCoreDeviceResponse.getter(ListClientDevicesAssociatedWithCoreDeviceResponse::nextToken)).setter(ListClientDevicesAssociatedWithCoreDeviceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_CLIENT_DEVICES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssociatedClientDevice> associatedClientDevices;
    private final String nextToken;

    private ListClientDevicesAssociatedWithCoreDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.associatedClientDevices = builder.associatedClientDevices;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociatedClientDevices() {
        return this.associatedClientDevices != null && !(this.associatedClientDevices instanceof SdkAutoConstructList);
    }

    public final List<AssociatedClientDevice> associatedClientDevices() {
        return this.associatedClientDevices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedClientDevices() ? this.associatedClientDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClientDevicesAssociatedWithCoreDeviceResponse)) {
            return false;
        }
        ListClientDevicesAssociatedWithCoreDeviceResponse other = (ListClientDevicesAssociatedWithCoreDeviceResponse)((Object)obj);
        return this.hasAssociatedClientDevices() == other.hasAssociatedClientDevices() && Objects.equals(this.associatedClientDevices(), other.associatedClientDevices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClientDevicesAssociatedWithCoreDeviceResponse").add("AssociatedClientDevices", this.hasAssociatedClientDevices() ? this.associatedClientDevices() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedClientDevices": {
                return Optional.ofNullable(clazz.cast(this.associatedClientDevices()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClientDevicesAssociatedWithCoreDeviceResponse, T> g) {
        return obj -> g.apply((ListClientDevicesAssociatedWithCoreDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private List<AssociatedClientDevice> associatedClientDevices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClientDevicesAssociatedWithCoreDeviceResponse model) {
            super(model);
            this.associatedClientDevices(model.associatedClientDevices);
            this.nextToken(model.nextToken);
        }

        public final List<AssociatedClientDevice.Builder> getAssociatedClientDevices() {
            List<AssociatedClientDevice.Builder> result = AssociatedClientDeviceListCopier.copyToBuilder(this.associatedClientDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedClientDevices(Collection<AssociatedClientDevice.BuilderImpl> associatedClientDevices) {
            this.associatedClientDevices = AssociatedClientDeviceListCopier.copyFromBuilder(associatedClientDevices);
        }

        @Override
        public final Builder associatedClientDevices(Collection<AssociatedClientDevice> associatedClientDevices) {
            this.associatedClientDevices = AssociatedClientDeviceListCopier.copy(associatedClientDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClientDevices(AssociatedClientDevice ... associatedClientDevices) {
            this.associatedClientDevices(Arrays.asList(associatedClientDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClientDevices(Consumer<AssociatedClientDevice.Builder> ... associatedClientDevices) {
            this.associatedClientDevices(Stream.of(associatedClientDevices).map(c -> (AssociatedClientDevice)((AssociatedClientDevice.Builder)AssociatedClientDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClientDevicesAssociatedWithCoreDeviceResponse build() {
            return new ListClientDevicesAssociatedWithCoreDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClientDevicesAssociatedWithCoreDeviceResponse> {
        public Builder associatedClientDevices(Collection<AssociatedClientDevice> var1);

        public Builder associatedClientDevices(AssociatedClientDevice ... var1);

        public Builder associatedClientDevices(Consumer<AssociatedClientDevice.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

