/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.model.AssociatedClientDevice;
import software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse;

public class ListClientDevicesAssociatedWithCoreDevicePublisher
implements SdkPublisher<ListClientDevicesAssociatedWithCoreDeviceResponse> {
    private final GreengrassV2AsyncClient client;
    private final ListClientDevicesAssociatedWithCoreDeviceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClientDevicesAssociatedWithCoreDevicePublisher(GreengrassV2AsyncClient client, ListClientDevicesAssociatedWithCoreDeviceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClientDevicesAssociatedWithCoreDevicePublisher(GreengrassV2AsyncClient client, ListClientDevicesAssociatedWithCoreDeviceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClientDevicesAssociatedWithCoreDeviceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClientDevicesAssociatedWithCoreDeviceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociatedClientDevice> associatedClientDevices() {
        Function<ListClientDevicesAssociatedWithCoreDeviceResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedClientDevices() != null) {
                return response.associatedClientDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClientDevicesAssociatedWithCoreDeviceResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClientDevicesAssociatedWithCoreDeviceResponseFetcher
    implements AsyncPageFetcher<ListClientDevicesAssociatedWithCoreDeviceResponse> {
        private ListClientDevicesAssociatedWithCoreDeviceResponseFetcher() {
        }

        public boolean hasNextPage(ListClientDevicesAssociatedWithCoreDeviceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClientDevicesAssociatedWithCoreDeviceResponse> nextPage(ListClientDevicesAssociatedWithCoreDeviceResponse previousPage) {
            if (previousPage == null) {
                return ListClientDevicesAssociatedWithCoreDevicePublisher.this.client.listClientDevicesAssociatedWithCoreDevice(ListClientDevicesAssociatedWithCoreDevicePublisher.this.firstRequest);
            }
            return ListClientDevicesAssociatedWithCoreDevicePublisher.this.client.listClientDevicesAssociatedWithCoreDevice((ListClientDevicesAssociatedWithCoreDeviceRequest)((Object)ListClientDevicesAssociatedWithCoreDevicePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

