/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportDataCharacterEncoding {
    UTF_8("UTF-8"),
    US_ASCII("US-ASCII"),
    ISO_8859_1("ISO-8859-1"),
    UTF_16_BE("UTF-16BE"),
    UTF_16_LE("UTF-16LE"),
    UTF_16("UTF-16"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportDataCharacterEncoding> VALUE_MAP;
    private final String value;

    private ImportDataCharacterEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportDataCharacterEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportDataCharacterEncoding> knownValues() {
        EnumSet<ImportDataCharacterEncoding> knownValues = EnumSet.allOf(ImportDataCharacterEncoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportDataCharacterEncoding.class, ImportDataCharacterEncoding::toString);
    }
}

