/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse;

public class ListAssessmentTemplatesPublisher
implements SdkPublisher<ListAssessmentTemplatesResponse> {
    private final InspectorAsyncClient client;
    private final ListAssessmentTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentTemplatesPublisher(InspectorAsyncClient client, ListAssessmentTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentTemplatesPublisher(InspectorAsyncClient client, ListAssessmentTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentTemplatesResponseFetcher
    implements AsyncPageFetcher<ListAssessmentTemplatesResponse> {
        private ListAssessmentTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentTemplatesResponse> nextPage(ListAssessmentTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentTemplatesPublisher.this.client.listAssessmentTemplates(ListAssessmentTemplatesPublisher.this.firstRequest);
            }
            return ListAssessmentTemplatesPublisher.this.client.listAssessmentTemplates((ListAssessmentTemplatesRequest)((Object)ListAssessmentTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

