/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse;

public class ListRulesPackagesPublisher
implements SdkPublisher<ListRulesPackagesResponse> {
    private final InspectorAsyncClient client;
    private final ListRulesPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRulesPackagesPublisher(InspectorAsyncClient client, ListRulesPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRulesPackagesPublisher(InspectorAsyncClient client, ListRulesPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRulesPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRulesPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRulesPackagesResponseFetcher
    implements AsyncPageFetcher<ListRulesPackagesResponse> {
        private ListRulesPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRulesPackagesResponse> nextPage(ListRulesPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListRulesPackagesPublisher.this.client.listRulesPackages(ListRulesPackagesPublisher.this.firstRequest);
            }
            return ListRulesPackagesPublisher.this.client.listRulesPackages((ListRulesPackagesRequest)((Object)ListRulesPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

