/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSuiteDefinitionsResponse
extends IotDeviceAdvisorResponse
implements ToCopyableBuilder<Builder, ListSuiteDefinitionsResponse> {
    private static final SdkField<List<SuiteDefinitionInformation>> SUITE_DEFINITION_INFORMATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suiteDefinitionInformationList").getter(ListSuiteDefinitionsResponse.getter(ListSuiteDefinitionsResponse::suiteDefinitionInformationList)).setter(ListSuiteDefinitionsResponse.setter(Builder::suiteDefinitionInformationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionInformationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuiteDefinitionInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSuiteDefinitionsResponse.getter(ListSuiteDefinitionsResponse::nextToken)).setter(ListSuiteDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_INFORMATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<SuiteDefinitionInformation> suiteDefinitionInformationList;
    private final String nextToken;

    private ListSuiteDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionInformationList = builder.suiteDefinitionInformationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSuiteDefinitionInformationList() {
        return this.suiteDefinitionInformationList != null && !(this.suiteDefinitionInformationList instanceof SdkAutoConstructList);
    }

    public final List<SuiteDefinitionInformation> suiteDefinitionInformationList() {
        return this.suiteDefinitionInformationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuiteDefinitionInformationList() ? this.suiteDefinitionInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuiteDefinitionsResponse)) {
            return false;
        }
        ListSuiteDefinitionsResponse other = (ListSuiteDefinitionsResponse)((Object)obj);
        return this.hasSuiteDefinitionInformationList() == other.hasSuiteDefinitionInformationList() && Objects.equals(this.suiteDefinitionInformationList(), other.suiteDefinitionInformationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSuiteDefinitionsResponse").add("SuiteDefinitionInformationList", this.hasSuiteDefinitionInformationList() ? this.suiteDefinitionInformationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionInformationList": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionInformationList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuiteDefinitionsResponse, T> g) {
        return obj -> g.apply((ListSuiteDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorResponse.BuilderImpl
    implements Builder {
        private List<SuiteDefinitionInformation> suiteDefinitionInformationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuiteDefinitionsResponse model) {
            super(model);
            this.suiteDefinitionInformationList(model.suiteDefinitionInformationList);
            this.nextToken(model.nextToken);
        }

        public final List<SuiteDefinitionInformation.Builder> getSuiteDefinitionInformationList() {
            List<SuiteDefinitionInformation.Builder> result = SuiteDefinitionInformationListCopier.copyToBuilder(this.suiteDefinitionInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuiteDefinitionInformationList(Collection<SuiteDefinitionInformation.BuilderImpl> suiteDefinitionInformationList) {
            this.suiteDefinitionInformationList = SuiteDefinitionInformationListCopier.copyFromBuilder(suiteDefinitionInformationList);
        }

        @Override
        public final Builder suiteDefinitionInformationList(Collection<SuiteDefinitionInformation> suiteDefinitionInformationList) {
            this.suiteDefinitionInformationList = SuiteDefinitionInformationListCopier.copy(suiteDefinitionInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suiteDefinitionInformationList(SuiteDefinitionInformation ... suiteDefinitionInformationList) {
            this.suiteDefinitionInformationList(Arrays.asList(suiteDefinitionInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suiteDefinitionInformationList(Consumer<SuiteDefinitionInformation.Builder> ... suiteDefinitionInformationList) {
            this.suiteDefinitionInformationList(Stream.of(suiteDefinitionInformationList).map(c -> (SuiteDefinitionInformation)((SuiteDefinitionInformation.Builder)SuiteDefinitionInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSuiteDefinitionsResponse build() {
            return new ListSuiteDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSuiteDefinitionsResponse> {
        public Builder suiteDefinitionInformationList(Collection<SuiteDefinitionInformation> var1);

        public Builder suiteDefinitionInformationList(SuiteDefinitionInformation ... var1);

        public Builder suiteDefinitionInformationList(Consumer<SuiteDefinitionInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

