/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTimeSeriesRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DescribeTimeSeriesRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(DescribeTimeSeriesRequest.getter(DescribeTimeSeriesRequest::alias)).setter(DescribeTimeSeriesRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("alias").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(DescribeTimeSeriesRequest.getter(DescribeTimeSeriesRequest::assetId)).setter(DescribeTimeSeriesRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(DescribeTimeSeriesRequest.getter(DescribeTimeSeriesRequest::propertyId)).setter(DescribeTimeSeriesRequest.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, ASSET_ID_FIELD, PROPERTY_ID_FIELD));
    private final String alias;
    private final String assetId;
    private final String propertyId;

    private DescribeTimeSeriesRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
    }

    public final String alias() {
        return this.alias;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTimeSeriesRequest)) {
            return false;
        }
        DescribeTimeSeriesRequest other = (DescribeTimeSeriesRequest)((Object)obj);
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTimeSeriesRequest").add("Alias", (Object)this.alias()).add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTimeSeriesRequest, T> g) {
        return obj -> g.apply((DescribeTimeSeriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String alias;
        private String assetId;
        private String propertyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTimeSeriesRequest model) {
            super(model);
            this.alias(model.alias);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTimeSeriesRequest build() {
            return new DescribeTimeSeriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTimeSeriesRequest> {
        public Builder alias(String var1);

        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

